/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class ManoASMWindow
extends Dialog
implements ActionListener {
    private Label lbInstructions1 = new Label("Paste your code into this window.  (Ctrl-V)");
    private Label lbInstructions2 = new Label("Commands:");
    private Panel pMainPanel = new Panel(new BorderLayout());
    private Panel pLowerPanel = new Panel(new GridLayout(1, 2));
    private Panel pLowerRightPanel = new Panel(new GridLayout(1, 2));
    private Button bGo = new Button(" Assemble/Load ");
    private Button bCancel = new Button("Cancel");
    private Button bClear = new Button("Clear");
    private TextArea taData = new TextArea();
    private Font MONOFONT = new Font("Monospaced", 0, 12);
    private Frame fDummyFrame = new Frame();
    private String sData = "";
    private ManoSymbolTable symbolTable;
    private ManoMemoryMap memoryMap;
    private ManoFileParser fileParser;
    private boolean result;
    private ManoSaveCode codeObject = null;

    public ManoASMWindow(Frame owner, ManoSymbolTable st, ManoMemoryMap mm, ManoSaveCode code) {
        super(owner, "Mano - Assembly Language Input", true);
        this.codeObject = code;
        this.setSize(700, 650);
        this.pMainPanel.add((Component)this.lbInstructions1, "North");
        this.pLowerPanel.add(this.lbInstructions2);
        this.pLowerRightPanel.add(this.bGo);
        this.pLowerRightPanel.add(this.bClear);
        this.pLowerRightPanel.add(this.bCancel);
        this.pLowerPanel.add(this.pLowerRightPanel);
        this.pMainPanel.add((Component)this.pLowerPanel, "South");
        this.pMainPanel.add((Component)this.taData, "Center");
        Font f = new Font("monospaced", 1, 16);
        this.taData.setFont(f);
        this.sData = this.codeObject.getCode();
        this.taData.setText(this.sData);
        this.add(this.pMainPanel);
        this.bGo.addActionListener(this);
        this.bCancel.addActionListener(this);
        this.bClear.addActionListener(this);
        this.symbolTable = st;
        this.memoryMap = mm;
    }

    public boolean getResult() {
        return this.result;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.bGo) {
            this.memoryMap.reset();
            this.symbolTable.reset();
            this.taData.setEditable(false);
            this.sData = this.taData.getText();
            this.codeObject.saveCode(this.sData);
            this.sData = new String(this.sData.trim());
            this.fileParser = new ManoFileParser(this.sData, this.fDummyFrame);
            if (this.fileParser.isSuccessful()) {
                this.buildSymbolTable();
                boolean closeOK = this.buildMemoryMap();
                if (closeOK) {
                    this.taData.setEditable(true);
                    this.result = this.memoryMap.getSize() > 0;
                    this.hide();
                } else {
                    this.taData.setEditable(true);
                }
            } else {
                this.taData.setEditable(true);
            }
        } else if (source == this.bCancel) {
            this.result = false;
            this.hide();
        } else if (source == this.bClear) {
            this.codeObject.clearCode();
            this.taData.setText("");
        }
    }

    private void buildSymbolTable() {
        char lineCounter = '\u0000';
        boolean more = true;
        int i = 0;
        while (i < this.fileParser.getSize() && more) {
            if (this.fileParser.hasLabel(i)) {
                char c = lineCounter;
                lineCounter = (char)(c + 1);
                this.symbolTable.addSymbol(c, this.fileParser.getArg(0, i));
            } else if (this.fileParser.getArg(1, i).equalsIgnoreCase("ORG")) {
                lineCounter = ManoUtil.hexToChar(this.fileParser.getArg(2, i));
            } else if (this.fileParser.getArg(1, i).equalsIgnoreCase("END")) {
                more = false;
            } else {
                lineCounter = (char)(lineCounter + '\u0001');
            }
            ++i;
        }
    }

    private boolean buildMemoryMap() {
        char lineCounter = '\u0000';
        boolean more = true;
        boolean success = true;
        int i = 0;
        int x = 0;
        boolean duplicates = false;
        String dupSymbol = null;
        while (x < this.symbolTable.getSize() && !duplicates) {
            int y = 0;
            while (y < x) {
                if (y != x && this.symbolTable.getLabelAtIndex(y).equalsIgnoreCase(this.symbolTable.getLabelAtIndex(x))) {
                    duplicates = true;
                    dupSymbol = new String(this.symbolTable.getLabelAtIndex(x));
                }
                ++y;
            }
            ++x;
        }
        if (duplicates) {
            new ManoErrorDialog(this.fDummyFrame, new String("Duplicate symbol error: " + dupSymbol)).show();
            more = false;
            success = false;
        }
        while (i < this.fileParser.getSize() && more) {
            if (this.fileParser.isPseudo(i)) {
                if (this.fileParser.getArg(1, i).equalsIgnoreCase("ORG")) {
                    lineCounter = ManoUtil.hexToChar(this.fileParser.getArg(2, i));
                } else if (this.fileParser.getArg(1, i).equalsIgnoreCase("END")) {
                    more = false;
                } else if (this.fileParser.getArg(1, i).equalsIgnoreCase("DEC")) {
                    char c = lineCounter;
                    lineCounter = (char)(c + '\u0001');
                    this.memoryMap.addEntry(c, ManoUtil.decToChar(this.fileParser.getArg(2, i)), this.fileParser.getLineContents(i));
                } else if (this.fileParser.getArg(1, i).equalsIgnoreCase("HEX")) {
                    char c = lineCounter;
                    lineCounter = (char)(c + '\u0001');
                    this.memoryMap.addEntry(c, ManoUtil.hexToChar(this.fileParser.getArg(2, i)), this.fileParser.getLineContents(i));
                }
            } else if (this.fileParser.getArg(1, i).equalsIgnoreCase("AND") || this.fileParser.getArg(1, i).equalsIgnoreCase("ADD") || this.fileParser.getArg(1, i).equalsIgnoreCase("LDA") || this.fileParser.getArg(1, i).equalsIgnoreCase("STA") || this.fileParser.getArg(1, i).equalsIgnoreCase("BUN") || this.fileParser.getArg(1, i).equalsIgnoreCase("BSA") || this.fileParser.getArg(1, i).equalsIgnoreCase("ISZ")) {
                if (this.symbolTable.getIndexOf(this.fileParser.getArg(2, i)) != -1) {
                    if (this.fileParser.getArgumentCount(i) == 3) {
                        char c = lineCounter;
                        lineCounter = (char)(c + '\u0001');
                        this.memoryMap.addEntry(c, (char)(ManoUtil.hexToChar(ManoOpcodeLookupTable.get(this.fileParser.getArg(1, i), true)) + this.symbolTable.getAddressAtIndex(this.symbolTable.getIndexOf(this.fileParser.getArg(2, i)))), this.fileParser.getLineContents(i));
                    } else {
                        char c = lineCounter;
                        lineCounter = (char)(c + '\u0001');
                        this.memoryMap.addEntry(c, (char)(ManoUtil.hexToChar(ManoOpcodeLookupTable.get(this.fileParser.getArg(1, i), false)) + this.symbolTable.getAddressAtIndex(this.symbolTable.getIndexOf(this.fileParser.getArg(2, i)))), this.fileParser.getLineContents(i));
                    }
                } else {
                    new ManoErrorDialog(this.fDummyFrame, new String("Unknown argument error: " + this.fileParser.getLineContents(i))).show();
                    more = false;
                    success = false;
                }
            } else {
                char c = lineCounter;
                lineCounter = (char)(c + '\u0001');
                this.memoryMap.addEntry(c, ManoUtil.hexToChar(ManoOpcodeLookupTable.get(this.fileParser.getArg(1, i))), this.fileParser.getLineContents(i));
            }
            ++i;
        }
        return success;
    }
}

