/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class ManoExportWindow
extends Dialog
implements ActionListener {
    private Label lbInstructions1 = new Label("Highlight text and use (Ctrl-C) to copy to clipboard.");
    private Label lbInstructions2 = new Label("Press the Got it! button to dismiss.");
    private Panel pMainPanel = new Panel(new BorderLayout());
    private Panel pLowerPanel = new Panel(new GridLayout(1, 2));
    private Button bGo = new Button("Got it!");
    private TextArea taData = new TextArea();
    private Font MONOFONT = new Font("Monospaced", 0, 12);
    private ManoHardware hardware;
    private ManoMemoryMap memoryMap;

    public ManoExportWindow(Frame owner, ManoMemoryMap mm, ManoHardware mh) {
        super(owner, "Mano - Memory Map Export", true);
        int yset = 0;
        int xset = 0;
        this.setSize(600 + xset, 400 + yset);
        this.pMainPanel.add((Component)this.lbInstructions1, "North");
        this.pLowerPanel.add(this.lbInstructions2);
        this.pLowerPanel.add(this.bGo);
        this.pMainPanel.add((Component)this.pLowerPanel, "South");
        this.pMainPanel.add((Component)this.taData, "Center");
        this.taData.setFont(this.MONOFONT);
        this.add(this.pMainPanel);
        this.bGo.addActionListener(this);
        this.memoryMap = mm;
        this.hardware = mh;
        this.fillData();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.hide();
    }

    private void fillData() {
        int i = 0;
        while (i < this.memoryMap.getSize()) {
            this.taData.append(ManoUtil.addressIntToHex(this.memoryMap.getAddressAtIndex(i)) + "\t" + ManoUtil.charToHex(this.hardware.getDataAtAddress(this.memoryMap.getAddressAtIndex(i)), 16) + "\n");
            ++i;
        }
    }
}

