/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class ManoMemoryMap {
    Vector map = new Vector(0, 5);

    public void addEntry(char address, char instruction, String comment) {
        this.map.addElement(new ManoMemoryMapNode(address, instruction, comment));
    }

    public int getIndexOf(char a) {
        int index = -1;
        boolean found = false;
        int i = 0;
        while (i < this.map.size() && !found) {
            if (this.getAddressAtIndex(i) == a) {
                found = true;
                index = i;
            }
            ++i;
        }
        return index;
    }

    public char getAddressAtIndex(int i) {
        return ((ManoMemoryMapNode)this.map.elementAt(i)).getAddress();
    }

    public char getInstructionAtIndex(int i) {
        return ((ManoMemoryMapNode)this.map.elementAt(i)).getInstruction();
    }

    public String getCommentAtIndex(int i) {
        if (i >= 0 && i < this.map.size()) {
            return new String(((ManoMemoryMapNode)this.map.elementAt(i)).getComment());
        }
        return new String();
    }

    public int getSize() {
        return this.map.size();
    }

    public void reset() {
        this.map = new Vector(0, 5);
    }

    private class ManoMemoryMapNode {
        char address;
        char instruction;
        String comment;

        public ManoMemoryMapNode(char a, char i, String c) {
            this.address = a;
            this.instruction = i;
            this.comment = new String(c);
            this.comment = new String(this.comment.replace('\t', ' '));
        }

        public char getAddress() {
            return this.address;
        }

        public char getInstruction() {
            return this.instruction;
        }

        public String getComment() {
            return new String(this.comment);
        }
    }
}

