/*
 * Decompiled with CFR 0.152.
 */
class ManoOpcodeLookupTable {
    private static final String[][] sMR = new String[][]{{"AND", "0000", "8000"}, {"ADD", "1000", "9000"}, {"LDA", "2000", "A000"}, {"STA", "3000", "B000"}, {"BUN", "4000", "C000"}, {"BSA", "5000", "D000"}, {"ISZ", "6000", "E000"}};
    private static final String[][] sRRIO = new String[][]{{"CLA", "7800"}, {"CLE", "7400"}, {"CMA", "7200"}, {"CME", "7100"}, {"CIR", "7080"}, {"CIL", "7040"}, {"INC", "7020"}, {"SPA", "7010"}, {"SNA", "7008"}, {"SZA", "7004"}, {"SZE", "7002"}, {"HLT", "7001"}, {"INP", "F800"}, {"OUT", "F400"}, {"SKI", "F200"}, {"SKO", "F100"}, {"ION", "F080"}, {"IOF", "F040"}};

    ManoOpcodeLookupTable() {
    }

    public static String get(String opcode, boolean indirect) {
        int index = ManoOpcodeLookupTable.getIndexMR(opcode);
        if (!indirect) {
            return new String(sMR[index][1]);
        }
        return new String(sMR[index][2]);
    }

    public static String get(String opcode) {
        int index = ManoOpcodeLookupTable.getIndexRRIO(opcode);
        return new String(sRRIO[index][1]);
    }

    private static int getIndexMR(String opcode) {
        int index = -1;
        int i = 0;
        while (i < 7 && index == -1) {
            if (sMR[i][0].equalsIgnoreCase(opcode)) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    private static int getIndexRRIO(String opcode) {
        int index = -1;
        int i = 0;
        while (i < 18 && index == -1) {
            if (sRRIO[i][0].equalsIgnoreCase(opcode)) {
                index = i;
            }
            ++i;
        }
        return index;
    }
}

