/*
 * Decompiled with CFR 0.152.
 */
class ManoRegister {
    int nBits;
    char cData;
    boolean isSC;
    ManoHardware manoh = null;

    public ManoRegister(int bits) {
        this.nBits = bits;
        this.cData = '\u0000';
        this.isSC = false;
    }

    public ManoRegister(int bits, boolean b, ManoHardware mh) {
        this.isSC = b;
        this.manoh = mh;
        this.nBits = bits;
        this.cData = '\u0000';
    }

    public char get() {
        return this.cData;
    }

    public boolean getBit(int bitNumber) {
        int nBitMask = 1;
        char bitMask = (char)(nBitMask <<= bitNumber);
        return (this.cData & bitMask) == bitMask;
    }

    public void shiftRight16(boolean bitIn) {
        this.cData = (char)(this.cData / 2);
        if (bitIn) {
            this.cData = (char)(this.cData + 32768);
        }
    }

    public void shiftLeft16(boolean bitIn) {
        this.cData = (char)(this.cData * 2);
        if (bitIn) {
            this.cData = (char)(this.cData + '\u0001');
        }
    }

    public void and(char c) {
        this.cData = (char)(this.cData & c);
    }

    public boolean add(char c) {
        int argument = this.cData + c;
        boolean overflow = false;
        switch (this.nBits) {
            case 16: {
                if (argument <= 65535) break;
                overflow = true;
                argument -= 65536;
                break;
            }
            case 12: {
                if (argument <= 4095) break;
                overflow = true;
                argument -= 4096;
                break;
            }
            case 8: {
                if (argument <= 255) break;
                overflow = true;
                argument -= 256;
                break;
            }
            case 4: {
                if (argument <= 15) break;
                overflow = true;
                argument -= 16;
                break;
            }
            default: {
                System.err.println("Error - default value at switch");
            }
        }
        this.cData = (char)argument;
        return overflow;
    }

    public void inc() {
        int argument = this.cData + '\u0001';
        boolean overflow = false;
        switch (this.nBits) {
            case 16: {
                overflow = argument == 65536;
                break;
            }
            case 12: {
                overflow = argument == 4096;
                break;
            }
            case 8: {
                overflow = argument == 256;
                break;
            }
            case 4: {
                overflow = argument == 16;
                break;
            }
            default: {
                System.err.println("Error - default value at switch");
            }
        }
        if (overflow) {
            argument = 0;
        }
        this.cData = (char)argument;
    }

    public void set(char data) {
        int nBitMask;
        int nBitMask16 = 65535;
        int nBitMask12 = 4095;
        int nBitMask8 = 255;
        int nBitMask4 = 15;
        this.reset();
        switch (this.nBits) {
            case 16: {
                nBitMask = nBitMask16;
                break;
            }
            case 12: {
                nBitMask = nBitMask12;
                break;
            }
            case 8: {
                nBitMask = nBitMask8;
                break;
            }
            case 4: {
                nBitMask = nBitMask4;
                break;
            }
            default: {
                nBitMask = 0;
            }
        }
        char bitMask = (char)nBitMask;
        int nData = data & bitMask;
        this.cData = (char)nData;
    }

    public void reset() {
        this.cData = '\u0000';
    }

    public void complement() {
        this.cData = (char)(65535 - this.cData);
    }
}

