/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class ManoAmain
extends Applet
implements ActionListener,
ItemListener {
    private ManoDisplay display;
    private Button bLoad = new Button("Load");
    private Button bUnload = new Button("Unload");
    private Button bReset = new Button("Reset");
    private Button bInputEnable = new Button("Input Enable");
    private Button bOutputEnable = new Button("Output Enable");
    private Button bStep = new Button("Step");
    private Button bRun = new Button("Run");
    private Button bStop = new Button("Stop");
    private Button bExport = new Button("Export Memory Map");
    private Button bMicroMacro = new Button("Micro/Macro");
    private Button bOUTwindow = new Button("Output window");
    private Button bHelp = new Button("Help");
    private Label lbRunSpeed = new Label("Run Speed:");
    private CheckboxGroup cbgSpeed = new CheckboxGroup();
    private Checkbox cbSlow = new Checkbox("Slow", false, this.cbgSpeed);
    private Checkbox cbMedium = new Checkbox("Medium", false, this.cbgSpeed);
    private Checkbox cbFast = new Checkbox("Fast", true, this.cbgSpeed);
    private Frame fDummyFrame = new Frame();
    private Dimension NARROWBUTTON = new Dimension(64, 24);
    private Dimension WIDEBUTTON = new Dimension(100, 24);
    private Dimension XWIDEBUTTON = new Dimension(150, 24);
    private Dimension XMEDIUMLABEL = new Dimension(100, 18);
    private Dimension CBSIZE = new Dimension(100, 24);
    private ManoASMWindow assembler;
    private ManoHardware hardware;
    private ManoSymbolTable symbolTable;
    private ManoMemoryMap memoryMap;
    ManoSaveCode code = new ManoSaveCode();

    @Override
    public void init() {
        this.print_explanations();
        this.hardware = new ManoHardware(this);
        this.symbolTable = new ManoSymbolTable();
        this.memoryMap = new ManoMemoryMap();
        this.display = new ManoDisplay(this.hardware, this.symbolTable, this.memoryMap);
        this.hardware.associateManoDisplay(this.display);
        this.hardware.associateManoMemoryMap(this.memoryMap);
        this.setLayout(null);
        this.setSize(780, 970);
        this.build();
        this.setActionButtonsEnabled(false);
        this.awaken();
        this.display.updateAll();
    }

    private void build() {
        int y = 400;
        int yvis = 400;
        this.display.setSize(600 + y, 430 + yvis + 200);
        this.display.setLocation(0, 0);
        this.bLoad.setSize(this.NARROWBUTTON);
        this.bLoad.setLocation(10, 10);
        this.display.add(this.bLoad);
        this.bUnload.setSize(this.NARROWBUTTON);
        this.bUnload.setLocation(84, 10);
        this.display.add(this.bUnload);
        this.bUnload.setEnabled(false);
        this.bReset.setSize(this.NARROWBUTTON);
        this.bReset.setLocation(158, 10);
        this.display.add(this.bReset);
        this.bReset.setEnabled(false);
        this.bInputEnable.setSize(this.WIDEBUTTON);
        this.bInputEnable.setLocation(300, 80);
        this.display.add(this.bInputEnable);
        this.bInputEnable.setEnabled(false);
        this.bMicroMacro.setSize(this.WIDEBUTTON);
        this.bMicroMacro.setLocation(230, 10);
        this.display.add(this.bMicroMacro);
        this.bHelp.setSize(this.NARROWBUTTON);
        this.bHelp.setLocation(340, 10);
        this.display.add(this.bHelp);
        this.bOUTwindow.setSize(this.WIDEBUTTON);
        this.bOUTwindow.setLocation(440, 10);
        this.display.add(this.bOUTwindow);
        this.bOUTwindow.setEnabled(false);
        int yButton = 40;
        this.bOutputEnable.setSize(this.WIDEBUTTON);
        this.bOutputEnable.setLocation(300, 110 + yButton);
        this.display.add(this.bOutputEnable);
        this.bOutputEnable.setEnabled(false);
        int ctrlButton = 200;
        this.bStep.setSize(this.WIDEBUTTON);
        this.bStep.setLocation(300, 150 + yButton + ctrlButton);
        this.display.add(this.bStep);
        this.bStep.setEnabled(false);
        this.bRun.setSize(this.WIDEBUTTON);
        this.bRun.setLocation(300, 180 + yButton + ctrlButton);
        this.display.add(this.bRun);
        this.bRun.setEnabled(false);
        this.bStop.setSize(this.WIDEBUTTON);
        this.bStop.setLocation(300, 210 + yButton + ctrlButton);
        this.display.add(this.bStop);
        this.bStop.setEnabled(false);
        this.bExport.setSize(this.XWIDEBUTTON);
        int memMapY = 715;
        this.bExport.setLocation(430, 176 + memMapY + yButton);
        this.display.add(this.bExport);
        this.bExport.setEnabled(false);
        this.lbRunSpeed.setSize(this.XMEDIUMLABEL);
        this.lbRunSpeed.setLocation(300, 260 + yButton + ctrlButton);
        this.display.add(this.lbRunSpeed);
        this.cbSlow.setSize(this.CBSIZE);
        this.cbSlow.setLocation(300, 280 + yButton + ctrlButton);
        this.display.add(this.cbSlow);
        this.cbMedium.setSize(this.CBSIZE);
        this.cbMedium.setLocation(300, 305 + yButton + ctrlButton);
        this.display.add(this.cbMedium);
        this.cbFast.setSize(this.CBSIZE);
        this.cbFast.setLocation(300, 330 + yButton + ctrlButton);
        this.display.add(this.cbFast);
        this.add(this.display);
    }

    private void awaken() {
        this.bLoad.addActionListener(this);
        this.bUnload.addActionListener(this);
        this.bReset.addActionListener(this);
        this.bInputEnable.addActionListener(this);
        this.bMicroMacro.addActionListener(this);
        this.bOUTwindow.addActionListener(this);
        this.bHelp.addActionListener(this);
        this.bOutputEnable.addActionListener(this);
        this.bStep.addActionListener(this);
        this.bRun.addActionListener(this);
        this.bStop.addActionListener(this);
        this.bExport.addActionListener(this);
        this.cbSlow.addItemListener(this);
        this.cbMedium.addItemListener(this);
        this.cbFast.addItemListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.bLoad) {
            this.assembler = new ManoASMWindow(this.fDummyFrame, this.symbolTable, this.memoryMap, this.code);
            this.assembler.setVisible(true);
            if (this.assembler.getResult()) {
                this.hardware.initialize(this.memoryMap);
                this.hardware.associateManoMemoryMap(this.memoryMap);
                this.display.updateAll();
                this.bUnload.setEnabled(true);
                this.bReset.setEnabled(true);
                this.bExport.setEnabled(true);
                this.setActionButtonsEnabled(true);
            }
        } else if (source == this.bUnload) {
            this.bUnload.setEnabled(false);
            this.setActionButtonsEnabled(false);
            this.symbolTable.reset();
            this.memoryMap.reset();
            this.hardware.reset();
            this.display.updateAll();
            this.bLoad.setEnabled(true);
            this.bReset.setEnabled(false);
            this.bExport.setEnabled(false);
            this.hardware.SetmicroMacro();
        } else if (source == this.bReset) {
            this.hardware.initialize(this.memoryMap);
            this.display.updateAll();
            this.hardware.SetmicroMacro();
        } else if (source == this.bInputEnable) {
            this.hardware.inputEnable();
        } else if (source == this.bMicroMacro) {
            this.hardware.microMacro();
        } else if (source == this.bOUTwindow) {
            this.hardware.createOUTwindow();
        } else if (source == this.bHelp) {
            System.out.println("YH@ source == bHelp ***");
            new ManoHelp().setVisible(true);
        } else if (source == this.bOutputEnable) {
            this.hardware.outputEnable();
        } else if (source == this.bStep) {
            this.hardware.manoStep();
        } else if (source == this.bRun) {
            this.bRun.setEnabled(false);
            this.bStop.setEnabled(true);
            this.bUnload.setEnabled(false);
            this.bReset.setEnabled(false);
            this.bStep.setEnabled(false);
            this.bExport.setEnabled(false);
            this.hardware.manoStart();
        } else if (source == this.bStop) {
            this.hardware.manoStop();
            this.bStop.setEnabled(false);
            this.bUnload.setEnabled(true);
            this.bReset.setEnabled(true);
            this.bStep.setEnabled(true);
            this.bRun.setEnabled(true);
            this.bExport.setEnabled(true);
        } else if (source == this.bExport) {
            new ManoExportWindow(this.fDummyFrame, this.memoryMap, this.hardware).show();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        Object source = ie.getSource();
        if (source == this.cbSlow) {
            this.hardware.setRunSpeed(0);
        } else if (source == this.cbMedium) {
            this.hardware.setRunSpeed(1);
        } else if (source == this.cbFast) {
            this.hardware.setRunSpeed(2);
        }
    }

    public void informStop() {
        this.bStop.setEnabled(false);
        this.bUnload.setEnabled(true);
        this.bReset.setEnabled(true);
        this.bStep.setEnabled(true);
        this.bRun.setEnabled(true);
        this.bExport.setEnabled(true);
    }

    private void setActionButtonsEnabled(boolean b) {
        this.bInputEnable.setEnabled(b);
        this.bOutputEnable.setEnabled(b);
        this.bStep.setEnabled(b);
        this.bRun.setEnabled(b);
    }

    private void print_explanations() {
        System.out.println("Yigal Hoffner Mano CPU Simulator version 4.2 - 21 November 2009");
        System.out.println("Modified, debugged, changed, transformed, botched, de-botched from Rob Campbell's original simulator.");
        System.out.println("\nThe Visible registers: ");
        String accS = "a general purpose processing register. Arithmetic and logical operations are performed on this register, on values brought and stored in main memory.";
        System.out.println("\tAccumulator (Acc):" + accS);
        String inprS = "Input register: keyboard characters are placed in this register and loaded to the Accumulator with the INP instruction .";
        String outprS = "Output register: Accumulator content can be placed in this register using the operation OUT.";
        System.out.println("\tINPR: " + inprS);
        System.out.println("\tOUTPR: " + outprS);
        System.out.println("The Visible flags: ");
        System.out.println("\tFlag E: end carry out from addition - in ALU.");
        System.out.println("\t  Affected by result of ADDA operation and CLE (clear E) & CME (complement E) operations.");
        System.out.println("\tFlag IEN: Interrupt enable flag. Affected by instructions IOF (I=0) disable; ION (I=1) enable.");
        System.out.print("\tFlag FGI: Input available flag: 1 => input available; 0 => input taken.");
        System.out.println("  Affected by input device - user action.");
        System.out.print("\tFlag FGO: Output consumed flag: 1 => ready to receive output; 0 => busy. Affected by output device.");
        System.out.println("\nThe Invisible registers: ");
        System.out.println("\tPC: points to the next instruction in memory to be executed. ");
        System.out.println("\tAR: holds the address of the memory location from/to which a word is to be read from or written to.");
        System.out.println("\tDR: holds the operand brought from memory.");
        System.out.println("\tTR: A temporary internal CPU register.");
        System.out.println("\tIR: holds & interprets the current instruction to be executed.");
        System.out.println("\tSC: Sequence Counter - provides the CPU internal clock that controls the sequence of micro-instructions.");
        System.out.println("The Invisible flags: ");
        System.out.print("\tFlag I: I=0 => Direct addressing; I = 1 => Indirect addressing.");
        System.out.println("  Affected by instruction m/c code addressing mode.");
        System.out.println("\tFlag S: Start/stop flip-flop - affected by HLT (Halt).");
        System.out.println("\tFlag R: Interrup request: 0 => normal instruction cycle; 1 => Interrupt request pending.");
        System.out.println("\tAffected by actions external to CPU (I/O).");
    }
}

