/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;

public class ManoDisplay
extends Panel {
    private Label lbRegisters = new Label("Visible Registers & Flags:");
    private Label lbAC = new Label("AC:");
    private Label lbINPR = new Label("INPR:");
    private Label lbOUTR = new Label("OUTR:");
    private Label lbIEN = new Label("IEN:");
    private Label lbFGI = new Label("FGI:");
    private Label lbFGO = new Label("FGO:");
    private Label lbAssLab = new Label("Currently executing Assembly Instruction:");
    private Label lbSymbolTable = new Label("Address Symbol Table:");
    private Label lbSTHeader = new Label("Address  Label");
    private Label lbMemoryMap = new Label("Memory Map:");
    private Label lbMMHeader = new Label("Address  HEXCode");
    private Label lbE = new Label("E:");
    private Label lbIR = new Label("IR:");
    private Label lbAR = new Label("AR:");
    private Label lbDR = new Label("DR:");
    private Label lbTR = new Label("TR:");
    private Label lbPC = new Label("PC:");
    private Label lbSC = new Label("SC:");
    private Label lbFlipFlops = new Label("Flip-Flops:");
    private Label lbI = new Label("I:");
    private Label lbS = new Label("S:");
    private Label lbR = new Label("R:");
    private Label lbMicro_Instr = new Label("Micro-Instruction:");
    private TextField tfAC = new TextField(4);
    private TextField tfINPR = new TextField(1);
    private TextField tfOUTR = new TextField(1);
    private TextField tfIEN = new TextField(1);
    private TextField tfFGI = new TextField(1);
    private TextField tfFGO = new TextField(1);
    private TextField tfAssemb_Instr = new TextField(180);
    private TextField tfE = new TextField(1);
    private TextField visible_line = new TextField(32);
    private TextField ctrl_line = new TextField(32);
    private TextField sep_line = new TextField(32);
    private TextField tfMicro_Instr = new TextField(60);
    private TextField tfIR = new TextField(4);
    private TextField tfAR = new TextField(3);
    private TextField tfDR = new TextField(4);
    private TextField tfTR = new TextField(4);
    private TextField tfPC = new TextField(3);
    private TextField tfSC = new TextField(1);
    private TextField tfI = new TextField(1);
    private TextField tfS = new TextField(1);
    private TextField tfR = new TextField(1);
    private List lSymbolTable = new List();
    private List lMemoryMap = new List();
    private Dimension NARROWLABEL = new Dimension(30, 18);
    private Dimension MEDIUMLABEL = new Dimension(40, 18);
    private Dimension XXMEDIUMLABEL = new Dimension(150, 18);
    private Dimension WIDELABEL = new Dimension(280, 18);
    private Dimension NARROWFIELD = new Dimension(28, 24);
    private Dimension NARROW1FIELD = new Dimension(15, 24);
    private Dimension MEDIUMFIELD = new Dimension(40, 24);
    private Dimension MEDIUM16FIELD = new Dimension(60, 24);
    private Dimension WIDEFIELD = new Dimension(250, 24);
    private Dimension veryWIDEFIELD = new Dimension(290, 24);
    private Dimension SHORTAREA = new Dimension(150, 350);
    private Dimension HORIZONTAL = new Dimension(400, 4);
    private Dimension VERTICAL = new Dimension(4, 100);
    int memMapY = 815;
    private Dimension TALLAREA = new Dimension(150, this.memMapY);
    private Font MONOFONT = new Font("Monospaced", 0, 12);
    private ManoHardware hardware;
    private ManoSymbolTable symbolTable;
    private ManoMemoryMap memoryMap;

    public ManoDisplay(ManoHardware mh, ManoSymbolTable mst, ManoMemoryMap mmm) {
        this.hardware = mh;
        this.symbolTable = mst;
        this.memoryMap = mmm;
        this.setLayout(null);
        this.setSize(600, 430);
        this.build();
    }

    public void updateAll() {
        this.updateAllWindows();
    }

    public void update() {
        this.updateDynamicWindows();
    }

    public void adjust(char address) {
        int index = this.memoryMap.getIndexOf(address);
        this.lMemoryMap.replaceItem(ManoUtil.addressIntToHex(this.memoryMap.getAddressAtIndex(index)) + "      " + ManoUtil.charToHex(this.hardware.getDataAtAddress(this.memoryMap.getAddressAtIndex(index)), 16), index);
    }

    public void select(char address) {
        int index = this.memoryMap.getIndexOf(address);
        this.lMemoryMap.select(index);
    }

    public char getInput() {
        String sInput = this.tfINPR.getText();
        if (sInput.length() > 0) {
            return sInput.charAt(0);
        }
        return '\u0000';
    }

    private void build() {
        int y = 0;
        int yvis = 0;
        this.lbRegisters.setSize(this.WIDELABEL);
        this.lbRegisters.setLocation(20, 50 + y);
        this.add(this.lbRegisters);
        this.ctrl_line.setSize(this.HORIZONTAL);
        this.ctrl_line.setLocation(20, 45 + y);
        this.add(this.ctrl_line);
        this.ctrl_line.setEditable(false);
        this.sep_line.setSize(this.VERTICAL);
        this.sep_line.setLocation(290, 80 + y);
        this.add(this.sep_line);
        this.sep_line.setEditable(false);
        this.lbE.setSize(this.NARROW1FIELD);
        this.lbE.setLocation(20, 120 + y);
        this.add(this.lbE);
        this.tfE.setSize(this.NARROW1FIELD);
        this.tfE.setLocation(40, 120 + y);
        this.add(this.tfE);
        this.tfE.setEditable(false);
        this.lbAC.setSize(this.MEDIUMLABEL);
        this.lbAC.setLocation(76, 100 + yvis);
        this.add(this.lbAC);
        this.tfAC.setSize(this.MEDIUM16FIELD);
        this.tfAC.setLocation(76, 120 + yvis);
        this.add(this.tfAC);
        this.tfAC.setEditable(false);
        this.lbINPR.setSize(this.MEDIUMLABEL);
        this.lbINPR.setLocation(220, 70 + yvis);
        this.add(this.lbINPR);
        this.lbOUTR.setSize(this.MEDIUMLABEL);
        this.lbOUTR.setLocation(220, 130 + y);
        this.add(this.lbOUTR);
        this.tfINPR.setSize(this.MEDIUMFIELD);
        this.tfINPR.setLocation(220, 90 + yvis);
        this.add(this.tfINPR);
        this.tfOUTR.setSize(this.MEDIUMFIELD);
        this.tfOUTR.setLocation(220, 140 + yvis + 10);
        this.add(this.tfOUTR);
        this.tfOUTR.setEditable(false);
        this.lbFGI.setSize(this.NARROWLABEL);
        this.lbFGI.setLocation(153, 90 + y);
        this.add(this.lbFGI);
        this.tfFGI.setSize(this.NARROW1FIELD);
        this.tfFGI.setLocation(185, 90 + y);
        this.add(this.tfFGI);
        this.tfFGI.setEditable(false);
        this.lbFGO.setSize(this.NARROWLABEL);
        this.lbFGO.setLocation(150, 150 + y);
        this.add(this.lbFGO);
        this.tfFGO.setSize(this.NARROW1FIELD);
        this.tfFGO.setLocation(185, 150 + y);
        this.add(this.tfFGO);
        this.tfFGO.setEditable(false);
        this.lbIEN.setSize(this.NARROWLABEL);
        this.lbIEN.setLocation(150, 195 + y);
        this.add(this.lbIEN);
        this.tfIEN.setSize(this.NARROW1FIELD);
        this.tfIEN.setLocation(185, 195 + y);
        this.add(this.tfIEN);
        this.tfIEN.setEditable(false);
        this.lbSymbolTable.setSize(this.XXMEDIUMLABEL);
        this.lbSymbolTable.setLocation(610, 50 + y);
        this.add(this.lbSymbolTable);
        this.lbSTHeader.setSize(this.XXMEDIUMLABEL);
        this.lbSTHeader.setLocation(610, 70 + y);
        this.lbSTHeader.setFont(this.MONOFONT);
        this.add(this.lbSTHeader);
        this.lSymbolTable.setSize(this.SHORTAREA);
        this.lSymbolTable.setLocation(610, 90 + y);
        this.lSymbolTable.setMultipleMode(false);
        this.lSymbolTable.setFont(this.MONOFONT);
        this.add(this.lSymbolTable);
        this.lbMemoryMap.setSize(this.XXMEDIUMLABEL);
        this.lbMemoryMap.setLocation(430, 50 + y);
        this.add(this.lbMemoryMap);
        this.lbMMHeader.setSize(this.XXMEDIUMLABEL);
        this.lbMMHeader.setLocation(430, 70 + y);
        this.lbMMHeader.setFont(this.MONOFONT);
        this.add(this.lbMMHeader);
        this.lMemoryMap.setSize(this.TALLAREA);
        this.lMemoryMap.setLocation(430, 90 + y);
        this.lMemoryMap.setMultipleMode(false);
        this.lMemoryMap.setFont(this.MONOFONT);
        this.add(this.lMemoryMap);
        this.lbAssLab.setSize(this.WIDELABEL);
        this.lbAssLab.setLocation(60, 220 + y);
        this.add(this.lbAssLab);
        this.tfAssemb_Instr.setSize(this.WIDEFIELD);
        this.tfAssemb_Instr.setLocation(60, 240 + y);
        this.add(this.tfAssemb_Instr);
        this.tfAssemb_Instr.setEditable(false);
        this.visible_line.setSize(this.HORIZONTAL);
        this.visible_line.setLocation(20, 275 + y);
        this.add(this.visible_line);
        this.visible_line.setEditable(false);
        this.lbMicro_Instr.setSize(this.WIDELABEL);
        this.lbMicro_Instr.setLocation(90, 280 + y);
        this.add(this.lbMicro_Instr);
        this.tfMicro_Instr.setSize(this.veryWIDEFIELD);
        this.tfMicro_Instr.setLocation(90, 300 + y);
        this.add(this.tfMicro_Instr);
        this.tfMicro_Instr.setEditable(false);
        int yInvis = 300;
        this.lbPC.setSize(this.MEDIUMLABEL);
        this.lbPC.setLocation(20, 30 + yInvis);
        this.add(this.lbPC);
        this.lbAR.setSize(this.MEDIUMLABEL);
        this.lbAR.setLocation(20, 60 + yInvis);
        this.add(this.lbAR);
        this.lbDR.setSize(this.MEDIUMLABEL);
        this.lbDR.setLocation(20, 90 + yInvis);
        this.add(this.lbDR);
        this.lbTR.setSize(this.MEDIUMLABEL);
        this.lbTR.setLocation(20, 120 + yInvis);
        this.add(this.lbTR);
        this.lbIR.setSize(this.MEDIUMLABEL);
        this.lbIR.setLocation(20, 150 + yInvis);
        this.add(this.lbIR);
        this.tfIR.setSize(this.MEDIUM16FIELD);
        this.tfIR.setLocation(60, 150 + yInvis);
        this.add(this.tfIR);
        this.tfIR.setEditable(false);
        this.tfAR.setSize(this.MEDIUMFIELD);
        this.tfAR.setLocation(60, 60 + yInvis);
        this.add(this.tfAR);
        this.tfAR.setEditable(false);
        this.tfDR.setSize(this.MEDIUM16FIELD);
        this.tfDR.setLocation(60, 90 + yInvis);
        this.add(this.tfDR);
        this.tfDR.setEditable(false);
        this.tfTR.setSize(this.MEDIUM16FIELD);
        this.tfTR.setLocation(60, 120 + yInvis);
        this.add(this.tfTR);
        this.tfTR.setEditable(false);
        this.tfPC.setSize(this.MEDIUMFIELD);
        this.tfPC.setLocation(60, 30 + yInvis);
        this.add(this.tfPC);
        this.tfPC.setEditable(false);
        this.lbFlipFlops.setSize(this.WIDELABEL);
        this.lbFlipFlops.setLocation(20, 190 + yInvis);
        this.add(this.lbFlipFlops);
        this.lbI.setSize(this.NARROWLABEL);
        this.lbI.setLocation(20, 210 + yInvis);
        this.add(this.lbI);
        this.lbS.setSize(this.NARROWLABEL);
        this.lbS.setLocation(68, 210 + yInvis);
        this.add(this.lbS);
        this.lbR.setSize(this.NARROWLABEL);
        this.lbR.setLocation(134, 210 + yInvis);
        this.add(this.lbR);
        this.tfI.setSize(this.NARROW1FIELD);
        this.tfI.setLocation(20, 230 + yInvis);
        this.add(this.tfI);
        this.tfI.setEditable(false);
        this.tfS.setSize(this.NARROW1FIELD);
        this.tfS.setLocation(68, 230 + yInvis);
        this.add(this.tfS);
        this.tfS.setEditable(false);
        this.tfR.setSize(this.NARROW1FIELD);
        this.tfR.setLocation(134, 230 + yInvis);
        this.add(this.tfR);
        this.tfR.setEditable(false);
        this.lbSC.setSize(this.NARROWLABEL);
        this.lbSC.setLocation(20, 300 + y);
        this.add(this.lbSC);
        this.tfSC.setSize(this.NARROW1FIELD);
        this.tfSC.setLocation(60, 300 + y);
        this.add(this.tfSC);
        this.tfSC.setEditable(false);
        this.setInvisibleMicro(false);
    }

    private void updateAllWindows() {
        this.updateRegisters();
        this.updateFlipFlops();
        this.updateSymbolTable();
        this.updateMemoryMap();
        this.updateInstruction();
        this.updateComments();
    }

    private void updateDynamicWindows() {
        this.updateRegisters();
        this.updateFlipFlops();
        this.updateInstruction();
        this.updateComments();
    }

    private void updateRegisters() {
        this.tfAC.setText(new String(ManoUtil.charToHex(this.hardware.getAC(), 16)));
        this.tfIR.setText(new String(ManoUtil.charToHex(this.hardware.getIR(), 16)));
        this.tfAR.setText(new String(ManoUtil.charToHex(this.hardware.getAR(), 12)));
        this.tfDR.setText(new String(ManoUtil.charToHex(this.hardware.getDR(), 16)));
        this.tfTR.setText(new String(ManoUtil.charToHex(this.hardware.getTR(), 16)));
        this.tfPC.setText(new String(ManoUtil.charToHex(this.hardware.getPC(), 12)));
        this.tfOUTR.setText(new String("" + this.hardware.getOUTR()));
        this.tfSC.setText(new String(ManoUtil.charToHex(this.hardware.getSC(), 4)));
    }

    private void updateFlipFlops() {
        this.tfI.setText(new String("" + ManoUtil.boolToInt(this.hardware.getI())));
        this.tfS.setText(new String("" + ManoUtil.boolToInt(this.hardware.getS())));
        this.tfE.setText(new String("" + ManoUtil.boolToInt(this.hardware.getE())));
        this.tfR.setText(new String("" + ManoUtil.boolToInt(this.hardware.getR())));
        this.tfIEN.setText(new String("" + ManoUtil.boolToInt(this.hardware.getIEN())));
        this.tfFGI.setText(new String("" + ManoUtil.boolToInt(this.hardware.getFGI())));
        this.tfFGO.setText(new String("" + ManoUtil.boolToInt(this.hardware.getFGO())));
    }

    private void updateInstruction() {
        this.tfMicro_Instr.setText(new String(this.hardware.getInstruction()));
    }

    private void updateComments() {
        this.tfAssemb_Instr.setText(new String(this.hardware.getComment()));
    }

    private void updateSymbolTable() {
        this.lSymbolTable.removeAll();
        int i = 0;
        while (i < this.symbolTable.getSize()) {
            this.lSymbolTable.add(ManoUtil.addressIntToHex(this.symbolTable.getAddressAtIndex(i)) + "      " + this.symbolTable.getLabelAtIndex(i));
            ++i;
        }
    }

    private void updateMemoryMap() {
        this.lMemoryMap.removeAll();
        int i = 0;
        while (i < this.memoryMap.getSize()) {
            this.lMemoryMap.add(ManoUtil.addressIntToHex(this.memoryMap.getAddressAtIndex(i)) + "      " + ManoUtil.signedIntToHex(this.memoryMap.getInstructionAtIndex(i)));
            ++i;
        }
    }

    public void setInvisibleMicro(boolean b) {
        this.lbIR.setVisible(b);
        this.lbAR.setVisible(b);
        this.lbDR.setVisible(b);
        this.lbTR.setVisible(b);
        this.lbPC.setVisible(b);
        this.lbSC.setVisible(b);
        this.lbFlipFlops.setVisible(b);
        this.lbI.setVisible(b);
        this.lbS.setVisible(b);
        this.lbR.setVisible(b);
        this.lbMicro_Instr.setVisible(b);
        this.tfMicro_Instr.setVisible(b);
        this.tfIR.setVisible(b);
        this.tfAR.setVisible(b);
        this.tfDR.setVisible(b);
        this.tfTR.setVisible(b);
        this.tfPC.setVisible(b);
        this.tfSC.setVisible(b);
        this.tfI.setVisible(b);
        this.tfS.setVisible(b);
        this.tfR.setVisible(b);
    }
}

