/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Frame;
import java.util.StringTokenizer;
import java.util.Vector;

class ManoFileParser {
    Vector lines = new Vector(0, 5);
    String sFileContents;
    String sCurrentLine;
    boolean success;
    StringTokenizer lineTok;
    ManoTokenizedLine currentLine;
    Frame fErrorFrame;

    public ManoFileParser(String dataLine, Frame errorFrame) {
        this.sFileContents = new String(dataLine);
        this.success = true;
        this.fErrorFrame = errorFrame;
        this.process();
    }

    public boolean isSuccessful() {
        return this.success;
    }

    public int getSize() {
        return this.lines.size();
    }

    public String getArg(int argNumber, int index) {
        return new String(((ManoTokenizedLine)this.lines.elementAt(index)).getArg(argNumber));
    }

    public String getLineContents(int index) {
        return new String(((ManoTokenizedLine)this.lines.elementAt(index)).getLineContents());
    }

    public boolean hasLabel(int index) {
        return ((ManoTokenizedLine)this.lines.elementAt(index)).hasLabel();
    }

    public boolean isCode(int index) {
        return ((ManoTokenizedLine)this.lines.elementAt(index)).isCode();
    }

    public boolean isValid(int index) {
        return ((ManoTokenizedLine)this.lines.elementAt(index)).isValid();
    }

    public boolean isPseudo(int index) {
        return ((ManoTokenizedLine)this.lines.elementAt(index)).isPseudo();
    }

    public int getArgumentCount(int index) {
        return ((ManoTokenizedLine)this.lines.elementAt(index)).getArgumentCount();
    }

    private void process() {
        boolean isOk = true;
        this.lineTok = new StringTokenizer(this.sFileContents, "\n");
        while (this.lineTok.hasMoreTokens() && isOk) {
            this.sCurrentLine = new String(this.lineTok.nextToken());
            this.sCurrentLine = new String(this.sCurrentLine.trim());
            if (this.sCurrentLine.equals("")) continue;
            this.currentLine = new ManoTokenizedLine(this.sCurrentLine);
            if (this.currentLine.isValid()) {
                if (!this.currentLine.isCode()) continue;
                this.lines.addElement(new ManoTokenizedLine(this.currentLine));
                continue;
            }
            isOk = false;
            new ManoErrorDialog(this.fErrorFrame, new String("Syntax error: " + this.sCurrentLine)).show();
        }
        this.success = isOk;
    }
}

