/*
 * Decompiled with CFR 0.152.
 */
public class ManoHardware
extends Thread {
    private ManoRegister AR;
    private ManoRegister PC;
    private ManoRegister DR;
    private ManoRegister AC;
    private ManoRegister IR;
    private ManoRegister TR;
    private ManoRegister OUTR;
    private ManoRegister INPR;
    private ManoRegister SC;
    private ManoFlipFlop I;
    private ManoFlipFlop S;
    private ManoFlipFlop E;
    private ManoFlipFlop R;
    private ManoFlipFlop IEN;
    private ManoFlipFlop_trigger FGI;
    private ManoFlipFlop_trigger FGO;
    boolean stopMicro = false;
    boolean longTermMicro = false;
    private ManoMemory mainMemory;
    private int decoder;
    private int runSpeed;
    private String instruction;
    private String comment;
    private ManoDisplay display;
    private ManoMemoryMap memoryMap;
    private ManoAmain mainApp;
    boolean interruptFlag = false;
    String MacroInstructionWindowString = "";
    ManoScreen tas = null;
    KB_Emulator kb = null;

    public ManoHardware(ManoAmain app) {
        this.mainApp = app;
        this.AR = new ManoRegister(12);
        this.PC = new ManoRegister(12);
        this.DR = new ManoRegister(16);
        this.AC = new ManoRegister(16);
        this.IR = new ManoRegister(16);
        this.TR = new ManoRegister(16);
        this.OUTR = new ManoRegister(8);
        this.INPR = new ManoRegister(8);
        this.SC = new ManoRegister(4, true, this);
        this.I = new ManoFlipFlop();
        this.S = new ManoFlipFlop();
        this.E = new ManoFlipFlop();
        this.R = new ManoFlipFlop();
        this.IEN = new ManoFlipFlop();
        this.FGI = new ManoFlipFlop_trigger();
        this.FGO = new ManoFlipFlop_trigger();
        this.mainMemory = new ManoMemory();
        this.start();
        this.runSpeed = 2;
        this.instruction = new String();
        this.comment = new String(this.MacroInstructionWindowString);
    }

    public void associateManoDisplay(ManoDisplay md) {
        this.display = md;
    }

    public void associateManoMemoryMap(ManoMemoryMap mm) {
        this.memoryMap = mm;
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (this.S.get()) {
                    this.manoStep();
                    this.display.update();
                    ManoHardware.sleep((2 - this.runSpeed) * 400);
                }
                ManoHardware.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public void inputEnable() {
        this.FGI.set();
    }

    public void createKB_simulation() {
        this.kb = new KB_Emulator();
    }

    public void createOUTwindow() {
        System.out.println("In createOUTwindow()");
        this.createKB_simulation();
        this.tas = new ManoScreen(this);
        this.tas.launchFrame();
        this.FGO.set();
    }

    public void destroyOUTwindow() {
        this.tas = null;
    }

    public void microMacro() {
        if (this.stopMicro) {
            this.stopMicro = false;
            this.longTermMicro = false;
            this.display.setInvisibleMicro(false);
        } else {
            this.stopMicro = true;
            this.longTermMicro = true;
            this.display.setInvisibleMicro(true);
        }
    }

    public void SetmicroMacro() {
        this.stopMicro = this.longTermMicro;
    }

    public void outputEnable() {
        this.FGO.set();
    }

    public void manoStart() {
        this.S.set(true);
    }

    public void manoStop() {
        this.S.set(false);
        this.display.update();
    }

    public void manoStep() {
        this.step();
        this.display.update();
    }

    public void setRunSpeed(int s) {
        this.runSpeed = s;
    }

    public void reset() {
        this.AR.reset();
        this.PC.reset();
        this.DR.reset();
        this.AC.reset();
        this.IR.reset();
        this.TR.reset();
        this.OUTR.reset();
        this.INPR.reset();
        this.SC.reset();
        this.I.reset();
        this.S.reset();
        this.E.reset();
        this.R.reset();
        this.IEN.reset();
        this.FGI.reset();
        this.FGO.reset();
        this.mainMemory.reset();
        this.instruction = new String();
        this.comment = new String(this.MacroInstructionWindowString);
    }

    public char getAR() {
        return this.AR.get();
    }

    public char getPC() {
        return this.PC.get();
    }

    public char getDR() {
        return this.DR.get();
    }

    public char getAC() {
        return this.AC.get();
    }

    public char getIR() {
        return this.IR.get();
    }

    public char getTR() {
        return this.TR.get();
    }

    public char getOUTR() {
        return this.OUTR.get();
    }

    public char getINPR() {
        return this.INPR.get();
    }

    public char getSC() {
        return this.SC.get();
    }

    public boolean getI() {
        return this.I.get();
    }

    public boolean getS() {
        return this.S.get();
    }

    public boolean getE() {
        return this.E.get();
    }

    public boolean getR() {
        return this.R.get();
    }

    public boolean getIEN() {
        return this.IEN.get();
    }

    public boolean getFGI() {
        return this.FGI.get();
    }

    public boolean getFGO() {
        return this.FGO.get();
    }

    public char getDataAtAddress(char a) {
        return this.mainMemory.get(a);
    }

    public String getInstruction() {
        return new String(this.instruction);
    }

    public String getComment() {
        return new String(this.comment);
    }

    public void initialize(ManoMemoryMap mm) {
        this.reset();
        this.mainMemory.loadMemoryMap(mm);
        this.instruction = new String();
        this.comment = new String(this.MacroInstructionWindowString);
        this.PC.set(mm.getAddressAtIndex(0));
    }

    private void step() {
        if (!this.R.get()) {
            this.instructionCycle();
        } else {
            if (this.SC.get() == '\u0000') {
                this.interruptFlag = true;
            }
            if (this.interruptFlag) {
                this.interruptCycle();
            } else {
                this.instructionCycle();
            }
        }
    }

    void instructionCycle() {
        char SCget = this.SC.get();
        block9: do {
            switch (this.SC.get()) {
                case '\u0000': {
                    this.display.select(this.PC.get());
                    this.comment = new String(this.memoryMap.getCommentAtIndex(this.memoryMap.getIndexOf(this.PC.get())));
                    this.instruction = new String("AR<-PC");
                    this.AR.set(this.PC.get());
                    this.SC.inc();
                    break;
                }
                case '\u0001': {
                    this.instruction = new String("IR<-M[AR], PC<-PC+1");
                    this.IR.set(this.mainMemory.get(this.AR.get()));
                    this.PC.set((char)(this.PC.get() + '\u0001'));
                    this.SC.inc();
                    break;
                }
                case '\u0002': {
                    this.instruction = new String("AR<-IR(0-11), I<-IR(15), D(0:7)<-Decode IR(12-14)");
                    this.AR.set(this.IR.get());
                    this.I.set(this.IR.getBit(15));
                    this.decode1214();
                    this.SC.inc();
                    break;
                }
                case '\u0003': {
                    this.setInterrupt_Rflag();
                    if (this.decoder != 7) {
                        if (!this.I.get()) {
                            this.instruction = new String("(do nothing)");
                            this.SC.inc();
                            break;
                        }
                        this.instruction = new String("AR<-M[AR]");
                        this.AR.set(this.mainMemory.get(this.AR.get()));
                        this.SC.inc();
                        break;
                    }
                    if (!this.I.get()) {
                        if (this.IR.getBit(11)) {
                            this.instruction = new String("AC<-0, SC<-0");
                            this.AC.set('\u0000');
                            this.SC.reset();
                            break;
                        }
                        if (this.IR.getBit(10)) {
                            this.instruction = new String("E<-0, SC<-0");
                            this.E.set(false);
                            this.SC.reset();
                            break;
                        }
                        if (this.IR.getBit(9)) {
                            this.instruction = new String("AC<-AC', SC<-0");
                            this.AC.complement();
                            this.SC.reset();
                            break;
                        }
                        if (this.IR.getBit(8)) {
                            this.instruction = new String("E<-E', SC<-0");
                            this.E.toggle();
                            this.SC.reset();
                            break;
                        }
                        if (this.IR.getBit(7)) {
                            this.instruction = new String("AC<-shr AC, AC(15)<-E, E<-AC(0), SC<-0");
                            if (!this.E.get()) {
                                this.E.set(this.AC.getBit(0));
                                this.AC.shiftRight16(false);
                                this.SC.reset();
                                break;
                            }
                            this.E.set(this.AC.getBit(0));
                            this.AC.shiftRight16(true);
                            this.SC.reset();
                            break;
                        }
                        if (this.IR.getBit(6)) {
                            this.instruction = new String("AC<-shl AC, AC(0)<-E, E<-AC(15), SC<-0");
                            if (!this.E.get()) {
                                this.E.set(this.AC.getBit(15));
                                this.AC.shiftLeft16(false);
                                this.SC.reset();
                                break;
                            }
                            this.E.set(this.AC.getBit(15));
                            this.AC.shiftLeft16(true);
                            this.SC.reset();
                            break;
                        }
                        if (this.IR.getBit(5)) {
                            this.instruction = new String("AC<-AC+1, SC<-0");
                            this.AC.inc();
                            this.SC.reset();
                            break;
                        }
                        if (this.IR.getBit(4)) {
                            this.instruction = new String("if (AC(15)=0) && AC != 0 then (PC<-PC+1), SC<-0");
                            if (!this.AC.getBit(15) && this.AC.get() != '\u0000') {
                                this.PC.inc();
                            }
                            this.SC.reset();
                            break;
                        }
                        if (this.IR.getBit(3)) {
                            this.instruction = new String("if (AC(15)=1) then (PC<-PC+1), SC<-0");
                            if (this.AC.getBit(15)) {
                                this.PC.inc();
                            }
                            this.SC.reset();
                            break;
                        }
                        if (this.IR.getBit(2)) {
                            this.instruction = new String("if (AC=0) then (PC<-PC+1), SC<-0");
                            if (this.AC.get() == '\u0000') {
                                this.PC.inc();
                            }
                            this.SC.reset();
                            break;
                        }
                        if (this.IR.getBit(1)) {
                            this.instruction = new String("if (E=0) then (PC<-PC+1), SC<-0");
                            if (!this.E.get()) {
                                this.PC.inc();
                            }
                            this.SC.reset();
                            break;
                        }
                        if (!this.IR.getBit(0)) continue block9;
                        this.stopMicro = true;
                        this.instruction = new String("S<-0");
                        this.S.set(false);
                        this.mainApp.informStop();
                        break;
                    }
                    if (this.IR.getBit(11)) {
                        this.instruction = new String("AC(0-7)<-INPR, FGI<-0, SC<-0");
                        this.INPR.set(this.display.getInput());
                        this.AC.set(this.INPR.get());
                        this.FGI.reset();
                        this.SC.reset();
                        break;
                    }
                    if (this.IR.getBit(10)) {
                        this.instruction = new String("OUTR<-AC(0-7), FGO<-0, SC<-0");
                        this.OUTR.set(this.AC.get());
                        if (this.tas != null) {
                            this.FGO.reset();
                            if (this.AC.get() == '\b' || this.AC.get() == '\u007f') {
                                String tx = this.tas.getScreenText();
                                System.out.println("Text is:" + tx);
                            }
                            this.tas.addText(this.AC.get());
                        } else {
                            this.FGO.reset();
                        }
                        this.SC.reset();
                        break;
                    }
                    if (this.IR.getBit(9)) {
                        this.instruction = new String("if (FGI=1) then (PC<-PC+1), SC<-0");
                        if (this.FGI.get()) {
                            this.PC.inc();
                        }
                        this.SC.reset();
                        break;
                    }
                    if (this.IR.getBit(8)) {
                        this.instruction = new String("if (FGO=1) then (PC<-PC+1), SC<-0");
                        if (this.FGO.get()) {
                            this.PC.inc();
                        }
                        this.SC.reset();
                        break;
                    }
                    if (this.IR.getBit(7)) {
                        this.instruction = new String("IEN<-1, SC<-0");
                        this.IEN.set(true);
                        this.SC.reset();
                        break;
                    }
                    if (!this.IR.getBit(6)) continue block9;
                    this.instruction = new String("IEN<-0, SC<-0");
                    this.IEN.set(false);
                    this.SC.reset();
                    break;
                }
                case '\u0004': {
                    this.setInterrupt_Rflag();
                    if (this.decoder == 0) {
                        this.instruction = new String("DR<-M[AR]");
                        this.DR.set(this.mainMemory.get(this.AR.get()));
                        this.SC.inc();
                        break;
                    }
                    if (this.decoder == 1) {
                        this.instruction = new String("DR<-M[AR]");
                        this.DR.set(this.mainMemory.get(this.AR.get()));
                        this.SC.inc();
                        break;
                    }
                    if (this.decoder == 2) {
                        this.instruction = new String("DR<-M[AR]");
                        this.DR.set(this.mainMemory.get(this.AR.get()));
                        this.SC.inc();
                        break;
                    }
                    if (this.decoder == 3) {
                        this.instruction = new String("M[AR]<-AC, SC<-0");
                        this.mainMemory.set(this.AR.get(), this.AC.get());
                        this.display.adjust(this.AR.get());
                        this.SC.reset();
                        break;
                    }
                    if (this.decoder == 4) {
                        this.instruction = new String("PC<-AR, SC<-0");
                        this.PC.set(this.AR.get());
                        this.SC.reset();
                        break;
                    }
                    if (this.decoder == 5) {
                        this.instruction = new String("M[AR]<-PC, AR<-AR+1");
                        this.mainMemory.set(this.AR.get(), this.PC.get());
                        this.display.adjust(this.AR.get());
                        this.AR.inc();
                        this.SC.inc();
                        break;
                    }
                    if (this.decoder != 6) continue block9;
                    this.instruction = new String("DR<-M[AR]");
                    this.DR.set(this.mainMemory.get(this.AR.get()));
                    this.SC.inc();
                    break;
                }
                case '\u0005': {
                    this.setInterrupt_Rflag();
                    if (this.decoder == 0) {
                        this.instruction = new String("AC<-AC^DR, SC<-0");
                        this.AC.and(this.DR.get());
                        this.SC.reset();
                        break;
                    }
                    if (this.decoder == 1) {
                        this.instruction = new String("AC<-AC+DR, SC<-0");
                        this.E.set(this.AC.add(this.DR.get()));
                        this.SC.reset();
                        break;
                    }
                    if (this.decoder == 2) {
                        this.instruction = new String("AC<-DR, SC<-0");
                        this.AC.set(this.DR.get());
                        this.SC.reset();
                        break;
                    }
                    if (this.decoder == 5) {
                        this.instruction = new String("PC<-AR, SC<-0");
                        this.PC.set(this.AR.get());
                        this.SC.reset();
                        break;
                    }
                    if (this.decoder != 6) continue block9;
                    this.instruction = new String("DR<-DR+1");
                    this.DR.inc();
                    this.SC.inc();
                    break;
                }
                case '\u0006': {
                    this.setInterrupt_Rflag();
                    this.instruction = new String("M[AR]<-DR, if (DR=0) then (PC<-PC+1), SC<-0");
                    this.mainMemory.set(this.AR.get(), this.DR.get());
                    this.display.adjust(this.AR.get());
                    if (this.DR.get() == '\u0000') {
                        this.PC.inc();
                    }
                    this.SC.reset();
                    break;
                }
                default: {
                    System.err.println("Error - default value at instruction cycle!");
                }
            }
        } while ((SCget = this.SC.get()) > '\u0000' && !this.stopMicro);
    }

    void setInterrupt_Rflag() {
        if (this.IEN.get() && (this.FGI.getChange() || this.FGO.getChange())) {
            this.R.set(true);
            this.FGO.resetChange();
            this.FGI.resetChange();
        }
    }

    void interruptCycle() {
        switch (this.SC.get()) {
            case '\u0000': {
                this.display.select(this.PC.get());
                this.comment = new String(this.memoryMap.getCommentAtIndex(this.memoryMap.getIndexOf(this.PC.get())));
                this.instruction = new String("AR<-0, TR<-PC");
                this.AR.set('\u0000');
                this.TR.set(this.PC.get());
                this.SC.inc();
                break;
            }
            case '\u0001': {
                this.instruction = new String("M[AR]<-TR, PC<-0");
                this.mainMemory.set(this.AR.get(), this.TR.get());
                this.display.adjust(this.AR.get());
                this.PC.set('\u0000');
                this.SC.inc();
                break;
            }
            case '\u0002': {
                this.instruction = new String("PC<-PC+1, IEN<-0, R<-0, SC<-0");
                this.PC.inc();
                this.IEN.reset();
                this.R.reset();
                this.FGO.resetChange();
                this.SC.reset();
                this.interruptFlag = false;
                break;
            }
            default: {
                System.err.println("Error - default value at interrupt cycle!");
            }
        }
    }

    public void setFGO() {
        this.FGO.set();
    }

    private void decode1214() {
        int result = 0;
        if (this.IR.getBit(12)) {
            ++result;
        }
        if (this.IR.getBit(13)) {
            result += 2;
        }
        if (this.IR.getBit(14)) {
            result += 4;
        }
        this.decoder = result;
    }
}

