/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.GroupLayout;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;

public class ManoHelp
extends JFrame
implements DocumentListener {
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JTextArea textArea;
    private static final String COMMIT_ACTION = "commit";
    private final List<String> words;
    private Mode mode = Mode.INSERT;

    public ManoHelp() {
        super("Mano CPU Help");
        this.initComponents();
        this.textArea.getDocument().addDocumentListener(this);
        InputMap im = this.textArea.getInputMap();
        ActionMap am = this.textArea.getActionMap();
        im.put(KeyStroke.getKeyStroke("ENTER"), COMMIT_ACTION);
        am.put(COMMIT_ACTION, new CommitAction());
        this.words = new ArrayList<String>(5);
        this.words.add("spark");
        this.words.add("special");
        this.words.add("spectacles");
        this.words.add("spectacular");
        this.words.add("swing");
        String t = this.get_explanations();
        this.textArea.setText(t);
        this.textArea.setEditable(false);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel("MANO CPU Help: Instruction set followed by the Register and Flag description");
        this.textArea = new JTextArea();
        this.setDefaultCloseOperation(2);
        this.textArea.setColumns(20);
        this.textArea.setLineWrap(true);
        this.textArea.setRows(5);
        this.textArea.setWrapStyleWord(true);
        this.jScrollPane1 = new JScrollPane(this.textArea);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        GroupLayout.ParallelGroup hGroup = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.SequentialGroup h1 = layout.createSequentialGroup();
        GroupLayout.ParallelGroup h2 = layout.createParallelGroup(GroupLayout.Alignment.TRAILING);
        h2.addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 812, Short.MAX_VALUE);
        h2.addComponent(this.jLabel1, GroupLayout.Alignment.LEADING, -1, 212, Short.MAX_VALUE);
        h1.addContainerGap();
        h1.addGroup(h2);
        h1.addContainerGap();
        hGroup.addGroup(GroupLayout.Alignment.TRAILING, h1);
        layout.setHorizontalGroup(hGroup);
        GroupLayout.ParallelGroup vGroup = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.SequentialGroup v1 = layout.createSequentialGroup();
        v1.addContainerGap();
        v1.addComponent(this.jLabel1);
        v1.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED);
        v1.addComponent(this.jScrollPane1, -1, 600, Short.MAX_VALUE);
        v1.addContainerGap();
        vGroup.addGroup(v1);
        layout.setVerticalGroup(vGroup);
        this.pack();
    }

    @Override
    public void changedUpdate(DocumentEvent ev) {
    }

    @Override
    public void removeUpdate(DocumentEvent ev) {
    }

    @Override
    public void insertUpdate(DocumentEvent ev) {
        if (ev.getLength() != 1) {
            return;
        }
        int pos = ev.getOffset();
        String content = null;
        try {
            content = this.textArea.getText(0, pos + 1);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        int w = pos;
        while (w >= 0) {
            if (!Character.isLetter(content.charAt(w))) break;
            --w;
        }
        if (pos - w < 2) {
            return;
        }
        String prefix = content.substring(w + 1).toLowerCase();
        int n = Collections.binarySearch(this.words, prefix);
        if (n < 0 && -n <= this.words.size()) {
            String match = this.words.get(-n - 1);
            if (match.startsWith(prefix)) {
                String completion = match.substring(pos - w);
                SwingUtilities.invokeLater(new CompletionTask(completion, pos + 1));
            }
        } else {
            this.mode = Mode.INSERT;
        }
    }

    private String get_explanations() {
        String xxx1 = "Yigal Hoffner Mano CPU Simulator version 4.2 - 21 November 2009\nModified, debugged, changed, transformed, botched, de-botched from R Campbell's original Mano simulator.\n\nAny comments, complaints and suggestions - please send an Email to: yigal.hoffner@gmx.net\n";
        String xxx2 = "\n\n\nAssembly Instructions Mano CPU assembly language instruction set (AC = Accumulator) M = Memory location)\n\nOpCode\tOperand\tDirect addressing mode\t\tIndirect addressing mode\t\nLDA\tM\tLDA M    // AC = [M]\t\tLDA M  I  // AC = [[M]]\t\nSTA\tM\tSTA M   // [M] = AC\t\tSTA M  I  // [[M]] = AC\t\nADD\tM\tADD M  // AC = AC + [M] If Overflow then E=1;  \tADD M  I  //AC = AC + [[M]]; If Overflow then E=1; \nAND\tM\tAND M   // AC = AC & [M] \t\tAND M  I  //AC = AC & [[M]]\t\nBUN\tM\tBranch unconditionally to M\t\tBranch unconditionally to [M]\t\nBSA\tM\tSave return address in M & branch to M+1 \tSave return address in [M] & branch to [M]+1\t\nISZ\tM\t[M] = [M] + 1; skip if [M] = 0 \t\tNone\t\n\nOpCode \tAction \t\t\tComment\t\nINC \tAC = AC+1; (E is not affected) \t\tIncrement AC\t\nCLA \tAC = 0 \t\t\tClear AC\t\nCLE \tE = 0 \t\t\tClear E (Carry)\t\nCMA \tAC = not(AC) \t\t\tComplement AC\t\nCME \tE = not(E) \t\t\tComplement E (1 bit)\t\nCIR \tCirculate right E and AC \t\tAC=shift-right AC; AC(15)=E; E=AC(0) \nCIL \tCirculate  left E and AC\t\tAC=shift-left AC; AC(0)=E; E=AC(15)\t\t\nSPA \tSkip if AC > 0\t\t\tSkip if  is positive AC\t\nSNA \tSkip if AC < 0\t\t\tSkip if negative AC\t\nSZA \tSkip if AC = 0\t\t\tSkip if AC = 0\t\nSZE \tSkip if E = 0\t\t\tSkip if E = 0\t\nSKI \tSkip on Input Flag (FGI) when input available\t\t\nSKO \tSkip on Output Flag (FGO) when output free\t\t\nHLT \tStop instruction cycle\t\tHalt\t\nION \tInterrupt enable flag on\t\tEnable interrupts\t\nIOF \tInterrupt enable flag off\t\tDisable interrupts\t\nINP \tAC = INPR \t\t\tTransfer Input register content to AC\nOUT \tOUTR = AC \t\t\tTransfer AC contents to Output register";
        String xxx3 = "\n\nThe Visible registers (Macro-Instruction or Assembly level): \n\tAccumulator (Acc):a general purpose processing register. Arithmetic and logical operations are performed on this register, on values brought and stored in main memory.";
        String xxx4 = "\n\tINPR: Input register: keyboard characters are placed in this register and loaded to the Accumulator with the INP instruction .";
        String xxx5 = "\n\tOUTPR: Output register: Accumulator content can be placed in this register using the operation OUT.";
        String xxx6 = "The Visible flags: \n\tFlag E: end carry out from addition - in ALU. Affected by result of ADDA operation and CLE (clear E) & CME (complement E) operations.\n\tFlag IEN: Interrupt enable flag. Affected by instructions IOF (I=0) disable; ION (I=1) enable.\n\tFlag FGI: Input available flag: 1 => input available; 0 => input taken. Affected by input device - user action.\n\tFlag FGO: Output consumed flag: 1 => ready to receive output; 0 => busy. Affected by output device.\n\nThe Invisible registers (Micro-Instruction level): \n\tPC: points to the next instruction in memory to be executed. \n\tAR: holds the address of the memory location from/to which a word is to be read from or written to.\n\tDR: holds the operand brought from memory.\n\tTR: A temporary internal CPU register.\n\tIR: holds & interprets the current instruction to be executed.\n\tSC: Sequence Counter - provides the CPU internal clock that controls the sequence of micro-instructions.\n\nThe Invisible flags (Micro-Instruction level): \n\tFlag I: I=0 => Direct addressing; I = 1 => Indirect addressing.\t  Affected by instruction m/c code addressing mode.\n\tFlag S: Start/stop flip-flop - affected by HLT (Halt).\n\tFlag R: Interrup request: 0 => normal instruction cycle; 1 => Interrupt request pending.\n\tAffected by actions external to CPU (I/O).";
        return String.valueOf(xxx1) + xxx3 + xxx4 + xxx5 + xxx6 + xxx2;
    }

    public static void main(String[] args) {
        new ManoHelp().setVisible(true);
    }

    private class CommitAction
    extends AbstractAction {
        private CommitAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (ManoHelp.this.mode == Mode.COMPLETION) {
                int pos = ManoHelp.this.textArea.getSelectionEnd();
                ManoHelp.this.textArea.insert(" ", pos);
                ManoHelp.this.textArea.setCaretPosition(pos + 1);
                ManoHelp.this.mode = Mode.INSERT;
            } else {
                ManoHelp.this.textArea.replaceSelection("\n");
            }
        }
    }

    private class CompletionTask
    implements Runnable {
        String completion;
        int position;

        CompletionTask(String completion, int position) {
            this.completion = completion;
            this.position = position;
        }

        @Override
        public void run() {
            ManoHelp.this.textArea.insert(this.completion, this.position);
            ManoHelp.this.textArea.setCaretPosition(this.position + this.completion.length());
            ManoHelp.this.textArea.moveCaretPosition(this.position);
            ManoHelp.this.mode = Mode.COMPLETION;
        }
    }

    private static enum Mode {
        INSERT,
        COMPLETION;

    }
}

