/*
 * Decompiled with CFR 0.152.
 */
import java.util.StringTokenizer;

class ManoTokenizedLine {
    String sLineContents;
    String sLabel;
    String sArg1;
    String sArg2;
    String sArg3;
    int nArguments;
    boolean hasLabel;
    boolean isCode;
    boolean isValid;
    boolean isPseudo;
    StringTokenizer tokenTok;

    public ManoTokenizedLine(String data) {
        this.sLineContents = new String(data);
        this.hasLabel = false;
        this.isCode = true;
        this.isValid = true;
        this.isPseudo = false;
        this.tokenize();
    }

    public ManoTokenizedLine(ManoTokenizedLine mtl) {
        this.sLineContents = new String(mtl.getLineContents());
        this.sLabel = new String(mtl.getArg(0));
        this.sArg1 = new String(mtl.getArg(1));
        this.sArg2 = new String(mtl.getArg(2));
        this.sArg3 = new String(mtl.getArg(3));
        this.nArguments = mtl.getArgumentCount();
        this.hasLabel = mtl.hasLabel();
        this.isCode = mtl.isCode();
        this.isValid = mtl.isValid();
        this.isPseudo = mtl.isPseudo();
    }

    public boolean hasLabel() {
        return this.hasLabel;
    }

    public boolean isCode() {
        return this.isCode;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public boolean isPseudo() {
        return this.isPseudo;
    }

    public String getArg(int index) {
        String returnString;
        switch (index) {
            case 0: {
                returnString = this.sLabel;
                break;
            }
            case 1: {
                returnString = this.sArg1;
                break;
            }
            case 2: {
                returnString = this.sArg2;
                break;
            }
            case 3: {
                returnString = this.sArg3;
                break;
            }
            default: {
                returnString = null;
            }
        }
        if (returnString != null) {
            return new String(returnString);
        }
        return new String();
    }

    public int getArgumentCount() {
        return this.nArguments;
    }

    public String getLineContents() {
        return new String(this.sLineContents);
    }

    private void tokenize() {
        if (!this.sLineContents.startsWith("/")) {
            this.tokenTok = new StringTokenizer(this.sLineContents, "/");
            this.sLineContents = new String(this.tokenTok.nextToken());
            this.sLineContents = new String(this.sLineContents.trim());
            if (this.sLineContents.indexOf(44) != -1) {
                this.hasLabel = true;
                this.tokenTok = new StringTokenizer(this.sLineContents, ",");
                this.sLabel = new String(this.tokenTok.nextToken());
                this.sLabel = new String(this.sLabel.trim());
                this.sLineContents = new String(this.tokenTok.nextToken());
                this.sLineContents = new String(this.sLineContents.trim());
            }
            this.tokenTok = new StringTokenizer(this.sLineContents);
            this.sArg1 = new String(this.tokenTok.nextToken());
            this.sArg1 = new String(this.sArg1.trim());
            if (this.sArg1.equalsIgnoreCase("END") || this.sArg1.equalsIgnoreCase("CLA") || this.sArg1.equalsIgnoreCase("CLE") || this.sArg1.equalsIgnoreCase("CMA") || this.sArg1.equalsIgnoreCase("CME") || this.sArg1.equalsIgnoreCase("CIR") || this.sArg1.equalsIgnoreCase("CIL") || this.sArg1.equalsIgnoreCase("INC") || this.sArg1.equalsIgnoreCase("SPA") || this.sArg1.equalsIgnoreCase("SNA") || this.sArg1.equalsIgnoreCase("SZA") || this.sArg1.equalsIgnoreCase("SZE") || this.sArg1.equalsIgnoreCase("HLT") || this.sArg1.equalsIgnoreCase("INP") || this.sArg1.equalsIgnoreCase("OUT") || this.sArg1.equalsIgnoreCase("SKI") || this.sArg1.equalsIgnoreCase("SKO") || this.sArg1.equalsIgnoreCase("ION") || this.sArg1.equalsIgnoreCase("IOF")) {
                if (this.tokenTok.hasMoreTokens()) {
                    this.isValid = false;
                    this.nArguments = 0;
                } else {
                    this.nArguments = 1;
                    if (this.sArg1.equalsIgnoreCase("END")) {
                        this.isPseudo = true;
                    }
                }
            } else if (this.sArg1.equalsIgnoreCase("AND") || this.sArg1.equalsIgnoreCase("ADD") || this.sArg1.equalsIgnoreCase("LDA") || this.sArg1.equalsIgnoreCase("STA") || this.sArg1.equalsIgnoreCase("BUN") || this.sArg1.equalsIgnoreCase("BSA") || this.sArg1.equalsIgnoreCase("ISZ") || this.sArg1.equalsIgnoreCase("ORG") || this.sArg1.equalsIgnoreCase("DEC") || this.sArg1.equalsIgnoreCase("HEX")) {
                this.sArg2 = new String(this.tokenTok.nextToken());
                this.sArg2 = new String(this.sArg2.trim());
                if (this.sArg1.equalsIgnoreCase("ORG") || this.sArg1.equalsIgnoreCase("DEC") || this.sArg1.equalsIgnoreCase("HEX")) {
                    if (this.tokenTok.hasMoreTokens()) {
                        this.isValid = false;
                        this.nArguments = 0;
                    } else {
                        this.isPseudo = true;
                        this.nArguments = 2;
                    }
                } else if (this.tokenTok.hasMoreTokens()) {
                    this.sArg3 = new String(this.tokenTok.nextToken());
                    this.sArg3 = new String(this.sArg3.trim());
                    if (this.sArg3.equalsIgnoreCase("I")) {
                        this.nArguments = 3;
                    } else {
                        this.isValid = false;
                        this.nArguments = 0;
                    }
                } else {
                    this.nArguments = 2;
                }
            } else {
                this.nArguments = 0;
                this.isValid = false;
            }
        } else {
            this.isCode = false;
        }
    }
}

