`timescale 1ns/1ns

module binaryAdder_tb;
  parameter N = 8;

  wire c,v;
  wire [N-1:0] sum;
  logic [N-1:0] x, y;

  binaryAdder #(N) ba(c, v, sum, x, y, 1'b0);

  initial begin
    logic signed [N-1:0] sums, xs, ys;

    $dumpfile("binaryAdder.vcd");
    $dumpvars;

    repeat (100) begin
      x = $urandom_range(0,2**N-1);
      y = $urandom_range(0,2**N-1);
      #60ns;
      xs = x;
      ys = y;
      sums = sum;
      $display("%d %d %d %d ** %d %d %d %d",
         x, y, sum, c, 
         xs, ys, sums, v);
    end
    $finish();
  end
                
endmodule