`timescale 1ns/1ns

module decoderE_tb;
  parameter SEL = 4;

  logic E;
  logic [SEL-1:0] sel;
  wire [2**SEL-1:0] T;
  decoderE  #(SEL) d(T, sel, E);

  initial begin
    $dumpfile("decoderE.vcd");
    $dumpvars;

    E = 0;
    repeat (100) begin
      if ($urandom_range(0,1)==0)
        E = E + 1;
      sel = $urandom_range(0,2**SEL-1);
      #40ns;
      $display("%d %d %x", E, sel, T);
    end
    $finish();
  end
endmodule