`timescale 1ns/1ns

module encoderV_tb;
  parameter SEL = 4;

  logic [2**SEL-1:0] in;
  wire [SEL-1:0] sel;
  wire v;

  encoderV  #(SEL) e(sel, v, in);
    
  initial begin
    $dumpfile("encoderV.vcd");
    $dumpvars;

    repeat (2**SEL) begin
      in = $urandom_range(0, 2**(2**SEL) - 1);
      #200ns;
      $display("%x %d %d", in, v, sel);
    end
    $finish();
end
                
endmodule