`timescale 1ns/1ns

module mux_tb;
  parameter SEL = 3;

  logic [SEL-1:0] sel;
  logic [2**SEL-1:0] x;

  wire T;

  mux #(SEL) m(T, x, sel);
    
  initial begin
    $dumpfile("mux.vcd");
    $dumpvars;

    sel = $urandom_range(0,2**SEL-1);

    repeat (100) begin
      x = $urandom_range(0,2**(2**SEL)-1);
      if ($urandom_range(0,3) == 0)
        sel = $urandom_range(0,2**SEL-1);
      #40ns;
      $display("%d %X %d", sel, x, T);
    end
    $finish();
  end
endmodule