`timescale 1ns/1ns

module muxMulti_tb;
  parameter SEL = 3;
  parameter WIDTH = 4;

  logic [SEL-1:0] sel;
  logic [WIDTH-1:0] t [2**SEL-1:0];
  wire [WIDTH-1:0] x;

  muxMulti #(SEL,WIDTH) m(x, t, sel);
    
  initial begin
    $dumpfile("muxMulti.vcd");
    $dumpvars;
    for (integer i = 0; i < 2**SEL; i++)
      $dumpvars(0, t[i]);

    sel = $urandom_range(0, 2**SEL-1);
    repeat (100) begin
      if ($urandom_range(0,3) == 0)
        sel = $urandom_range(0,2**SEL-1);
      for (integer i = 0; i < 2**SEL; i++)
        t[i] = $urandom_range(0, 2**WIDTH-1);
      #100ns;
    end
    $finish();
  end
endmodule