`timescale 1ns/1ns

module demuxMulti_tb;
  parameter SEL = 3;
  parameter WIDTH = 4;

  reg [SEL-1:0] sel;
  reg [WIDTH-1:0] in;
  wire [WIDTH-1:0] out [2**SEL-1:0];

  demuxMulti #(SEL,WIDTH) m(out, in, sel);
    
  initial begin
    $dumpfile("demuxMulti.vcd");
    $dumpvars;
    for (integer i=0; i < 2**SEL; i++)
      $dumpvars(0, out[i]);

    sel = $urandom_range(0,2**SEL-1);

    repeat (100) begin
      in = $urandom_range(0,2**WIDTH-1);
      if ($urandom_range(0,3) == 0)
        sel = $urandom_range(0,2**SEL-1);
      #100ns;
    end
    $finish();
  end                
endmodule