`timescale 1ns/1ns

module demuxZMulti_tb;
    parameter SEL = 3;
    parameter WIDTH = 4;

    reg [SEL-1:0] sel;
    reg [WIDTH-1:0] in;
    wire [WIDTH-1:0] out [2**SEL-1:0];

    demuxZMulti  #(SEL,WIDTH) m(out, in, sel);
    
    initial begin
        $dumpfile("demuxZMulti.vcd");
        $dumpvars;
        for (integer i=0; i < 2**SEL; i = i + 1)
            $dumpvars(0, out[i]);

        sel = $urandom_range(0,2**SEL-1);
        in  = $urandom_range(0,2**WIDTH);

        repeat (1000) begin
            #100
            if ($urandom_range(0,3) == 0)
                sel = $urandom_range(0,2**SEL-1);
        end

        $finish();
    end                
endmodule