`timescale 1ns/1ns

module decoder_tb;
  parameter SEL = 5;

  logic [SEL-1:0] sel;
  wire [2**SEL-1:0] T;
  decoder  #(SEL) d(T, sel);
    
  initial begin
    $dumpfile("decoder.vcd");
    $dumpvars;

    repeat (100) begin
      sel = $urandom_range(0,2**SEL-1);
      #40ns;
      $display("%d %x", sel, T);
    end
    $finish();
  end
                
endmodule