`timescale 1ns/1ns

module encoder #(parameter SEL=1) (
  output [SEL-1:0] sel,
  input [2**SEL-1:0] m
);
  for (genvar b = 0; b < SEL; b++) begin
    wire [2**SEL-1:0] consider;
    for (genvar i = 0; i < 2**SEL; i++) begin
      if ((i & (2**b)) !== 0)
        assign consider[i] = m[i];
      else
        assign consider[i] = 0;
      end
      orMulti #(2**SEL) o(sel[b],
                          consider);
  end
endmodule
