`timescale 1ns/1ns

module encoder_tb;
  parameter SEL = 4;

  logic [2**SEL-1:0] in;
  wire [SEL-1:0] sel;

  encoder #(SEL) e(sel, in);
    
  initial begin
    $dumpfile("encoder.vcd");
    $dumpvars;

    in = 1;
    repeat (2**SEL) begin
      #50ns;
      $display("%x %d", in, sel);
      in = in * 2;
    end
    $finish();
end
                
endmodule