`timescale 1ns/1ns

module encoderV #(parameter SEL=1) (
  output [SEL-1:0] sel,
  output v,
  input [2**SEL-1:0] d
);
  orMulti #(2**SEL) om(v, d);

  wire [2**SEL-1:0] dn;
  for (genvar i = 0; i < 2**SEL; i++) 
    notGate n(dn[i], d[i]);

  // Leave only leftmost asserted bit
  wire [2**SEL-1:0] m;
  for (genvar i = 0; i < 2**SEL; i++) begin
    wire [2**SEL-1:0] e;

    for (genvar j = 0; j < i; j++)
      assign e[j] = 1;

    assign e[i] = d[i];
    for (genvar j = i + 1; j < 2**SEL; j++)
      assign e[j] = dn[j];
        
    andMulti #(2**SEL) a(m[i], e);
  end

  encoder #(SEL) ee(sel, m);

endmodule
