`timescale 1ns/1ns

module muxMulti #(parameter SEL=1,
                            WIDTH=1) (
  output [WIDTH-1:0] out,
  input [WIDTH-1:0] in [2**SEL-1:0],
  input [SEL-1:0] sel
);
  for (genvar i = 0; i<WIDTH; i++) begin
    wire [2**SEL-1:0] t;

    for (genvar j = 0; j < 2**SEL; j++)
      assign t[j] = in[j][i:i];
      
    mux #(SEL) m(out[i], t, sel);
  end
endmodule
