`timescale 1ns/1ns

module demuxZ_tb;
  parameter SEL = 3;

  logic [SEL-1:0] sel;
  logic in;
  wire [2**SEL-1:0] out;

  demuxZ  #(SEL) m(out, in, sel);

  // So I can see lines separately
  for (genvar i = 0; i < 2**SEL; i++) begin 
    wire t;
    assign t = out[i:i];
  end
    
  initial begin
    $dumpfile("demuxZ.vcd");
    $dumpvars;

    sel = $urandom_range(0,2**SEL-1);
    in  = 1;

    repeat (100) begin
      #300ns;
      if ($urandom_range(0,3) == 0)
        sel = $urandom_range(0,2**SEL-1);
    end

    $finish();
  end                
endmodule