`timescale 1ns/1ns

module decoder #(parameter SEL=1) (
  output [2**SEL-1:0] d,
  input [SEL-1:0] sel
);

  wire [SEL-1:0] seln;

  for (genvar b = 0; b < SEL; b++)
    notGate n(seln[b], sel[b]);

  for (genvar i = 0; i < 2**SEL; i++) begin
    wire [SEL-1:0] s;
    for (genvar b = 0; b < SEL; b++) begin
      if ((i & (2**b)) !== 0)
        assign s[b] = sel[b];
      else
        assign s[b] = seln[b];
    end
    andMulti #(SEL) a(d[i], s);
  end
endmodule
