`timescale 1ns/1ns

module encoderV #(parameter SEL=1) (
  output [SEL-1:0] sel,
  output v,
  input [2**SEL-1:0] d
);
  orMulti #(2**SEL) om(v, d);

  wire [2**SEL-1:0] dn;
  for (genvar i = 0; i < 2**SEL; i++) 
    notGate n(dn[i:i], d[i:i]);

  // checking leading zeroes and then one
  wire [2**SEL-1:0] dd;
  for (genvar i = 0; i < 2**SEL; i++) begin
    wire [2**SEL-1:0] e;

    for (genvar j = 0; j < i; j++)
      assign e[j:j] = 1;

    assign e[i:i] = d[i:i];
    for (genvar j = i + 1; j < 2**SEL; j++)
      assign e[j:j] = dn[j:j];
        
    andMulti #(2**SEL) a(dd[i:i], e);
  end

  //
  // Usual encoder with dd replacing d
  //
  for (genvar b = 0; b < SEL; b++) begin
    wire [2**SEL-1:0] consider;
    for (genvar i = 0; i < 2**SEL; i++) begin
      if ((i & (2**b)) == 0)
        assign consider[i:i] = 0;
      else
        assign consider[i:i] = dd[i:i];
    end
    orMulti #(2**SEL) o(sel[b:b], consider);
  end
endmodule
