`timescale 1ns/1ns

module counter( 
  output x2,x1,x0,
  input init,
  input clk
);
  wire q2,q2n,q1,q1n,q0,q0n;
  wire d2,d1,d0;

  dffi dff0(q2,q2n,d2,1'b0,init,clk);
  dffi dff1(q1,q1n,d1,1'b0,init,clk);
  dffi dff2(q0,q0n,d0,1'b0,init,clk);

  andGate cd2(d2,q1 ,q0 );
  xorGate cd1(d1,q1 ,q0 );
  andGate cd0(d0,q2n,q0n);

  orGate cx2(x2,q2,d2);
  assign x1=d1;
  assign x0=q0n;

endmodule 
