`timescale 1ns/1ns

module counter( 
  output x2,x1,x0,
  input init,
  input clk
);
  wire q2,q2n,q1,q1n,q0,q0n;
  wire s2,r2,s1,r1,s0,r0;

  srffi srff0(q2,q2n,s2,r2,1'b0,init,clk);
  srffi srff1(q1,q1n,s1,r1,1'b0,init,clk);
  srffi srff2(q0,q0n,s0,r0,1'b0,init,clk);

  andGate cs2(s2,q1 ,q0 );
  assign r2=q2;
  xorGate cs1(s1,q1 ,q0 );
  andGate cr1(r1,q1 ,q0 );
  norGate cs0(s0,q2 ,q0 );
  andGate cr0(r0,q2n,q0);


  orGate cx2(x2,q2,s2);
  assign x1=s1;
  assign x0=q0n;

endmodule 
