`timescale 1ns/1ns

module counter( 
  output x2,x1,x0,
  input init,
  input clk
);
  wire q2,q2n,q1,q1n,q0,q0n;
  wire d2,d1,d0;

  dffi dff2(q2,q2n,d2,1'b0,init,clk);
  dffi dff1(q1,q1n,d1,1'b0,init,clk);
  dffi dff0(q0,q0n,d0,init,1'b0,clk);

  xnorGate cd2(d2,q1 ,q0 );

  wire q2norq1,q2norq0;
  norGate cq2q1(q2norq1,q2,q1);
  norGate cq2q0(q2norq0,q2,q0);
  orGate cd1(d1,q2norq1,q2norq0);

  orGate cd0(d0,q2,q2norq0);

  assign x2=q2;
  assign x1=q1;
  assign x0=q0;

endmodule 
