`timescale 1ns/1ns

module counter( 
  output x2,x1,x0,
  input init,
  input clk
);
  wire [2:0] q;
  wire [2:0] d;

  dffi dff2(q[2],,d[2],1'b0,init,clk);
  dffi dff1(q[1],,d[1],1'b0,init,clk);
  dffi dff0(q[0],,d[0],init,1'b0,clk);


  wire [2:0] e[2];
  assign e[1] = 3'b001;
  binaryAdder #(3) ba(,,e[0],q,3'b001,1'b0);

  wire eq;
  comparator #(3) com(,eq,,q,3'b101);

  muxMulti #(1,3) mm(d,e,eq);

  assign x2=q[2];
  assign x1=q[1];
  assign x0=q[0];

endmodule 
