`timescale 1ns/1ns

module gray3( 
  output x2,x1,x0,
  input init,
  input clk
);
  wire q2,q2n,q1,q1n,q0,q0n;
  wire d2,d1,d0;

  wire a20,a21,a22;
  andGate and20(a20,q1,q0n);
  andGate and21(a21,q2,q0);
  andGate and22(a22,q2,q1);
  or3Gate o2(d2,a20,a21,a22);

  wire a10,a11,a12;
  andGate and10(a10,q2n,q0);
  andGate and11(a11,q2n,q1);
  andGate and12(a12,q1,q0n);
  or3Gate o1(d1,a10,a11,a12);

  xnorGate o0(d0,q1,q2);

  dffi dff0(q2,q2n,d2,1'b0,init,clk);
  dffi dff1(q1,q1n,d1,1'b0,init,clk);
  dffi dff2(q0,q0n,d0,1'b0,init,clk);

  assign x2 = q2;
  assign x1 = q1;
  assign x0 = q0;

endmodule 
