`timescale 1ns/1ns

module gray3( 
  output x2,x1,x0,
  input init,
  input clk
);
  wire q2,q2n,q1,q1n,q0,q0n;
  wire s2,r2,s1,r1,s0,r0;

  andGate as2(s2,q1,q0n);
  andGate ar2(r2,q1n,q0n);

  andGate as1(s1,q2n,q0);
  andGate ar1(r1,q2,q0);

  xnorGate as0(s0,q2,q1);
  xorGate  ar0(r0,q2,q1);

  srffi srff0(q2,q2n,s2,r2,1'b0,init,clk);
  srffi srff1(q1,q1n,s1,r1,1'b0,init,clk);
  srffi srff2(q0,q0n,s0,r0,1'b0,init,clk);

  assign x2 = q2;
  assign x1 = q1;
  assign x0 = q0;

endmodule 
