`timescale 1ns/1ns

module calc(
  output goto,
  input  up,
  input  down,
  input  prev,
  input  curr,
  input  next
);
  wire upn,downn;
  notGate n1(upn,up);
  notGate n2(downn,down);

  wire stay,goDown,goUp;
  and3Gate aStay(stay,upn,downn,curr);
  and3Gate aDown(goDown,upn,down,next);
  andGate aUp(goUp,up,prev);

  or3Gate o(goto,stay,goDown,goUp);
endmodule

module gray3( 
  output [2:0] x,
  input  up,down,
  input  init,
  input  clk
);
  wire [7:0] d,q;

  dffi dff(q[0],,d[0],init,1'b0,clk);
  for (genvar i = 1; i < 8; i++)
    dffi dff(q[i],,d[i],1'b0,init,clk);

  calc c0(d[0],up,down,q[4],q[0],q[1]);
  calc c1(d[1],up,down,q[0],q[1],q[3]);
  calc c3(d[3],up,down,q[1],q[3],q[2]);
  calc c2(d[2],up,down,q[3],q[2],q[6]);
  calc c6(d[6],up,down,q[2],q[6],q[7]);
  calc c7(d[7],up,down,q[6],q[7],q[5]);
  calc c5(d[5],up,down,q[7],q[5],q[4]);
  calc c4(d[4],up,down,q[5],q[4],q[0]);

  encoder #(3) e(x,q);

endmodule 
