`timescale 1ns/1ns

module gray3_tb;

  wire clk;
  clock #(100) c(clk);

  logic init;
  logic up, down;
  wire [2:0] x;
  gray3 g(x, up,down, init, clk);

  initial begin

    $dumpfile("gray3.vcd");
    $dumpvars;

    init = 1;
    up = 1;
    down = 0;
    #70ns;
    init = 0; 

    #2000ns;
    $finish;
  end

  always @(posedge clk) begin
    up = $urandom_range(0,1);
    down = $urandom_range(0,1);
  end

endmodule
