`timescale 1ns/1ns

module mod3( 
  output m1,m0,
  input  x1,x0,
  input  init,
  input  clk
);
  wire x1n, x0n;
  notGate n1(x1n,x1);
  notGate n0(x0n,x0);

  wire q1, q1n, q0, q0n;

  wire a1, a2, a4, a5, a7, a8, aA, aB;

  and4Gate ag1(a1,q1n,q0n,x1n,x0 );
  and4Gate ag2(a2,q1n,q0n,x1 ,x0n);
  and4Gate ag4(a4,q1n,q0 ,x1n,x0n);
  and4Gate ag5(a5,q1n,q0 ,x1n,x0 );
  and4Gate ag7(a7,q1n,q0 ,x1 ,x0 );
  and4Gate ag8(a8,q1 ,q0n,x1n,x0n);
  and4Gate agA(aA,q1 ,q0n,x1 ,x0n);
  and4Gate agB(aB,q1 ,q0n,x1 ,x0 );

  wire d1,d0;
  or4Gate o1(d1,a2,a5,a8,aB);
  or4Gate o2(d0,a1,a4,a7,aA);

  dffi dff1(q1,q1n,d1,1'0b,init,clk);
  dffi dff0(q0,q0n,d0,1'0b,init,clk);

  assign m1 = q1;
  assign m0 = q0;

endmodule 
