`timescale 1ns/1ns

module disjoint11011( 
  output z,
  input  x,
  input  init,
  input  clk
);

  wire q5,q5n,q4,q4n,q3,q3n,q2,q2n,q1,q1n,q0,q0n;
  wire d5,d4,d3,d2,d1,d0;
  dffi dff5(q5,q5n,d5,1'b0,init,clk);
  dffi dff4(q4,q4n,d4,1'b0,init,clk);
  dffi dff3(q3,q3n,d3,1'b0,init,clk);
  dffi dff2(q2,q2n,d2,1'b0,init,clk);
  dffi dff1(q1,q1n,d1,1'b0,init,clk);
  dffi dff0(q0,q0n,d0,init,1'b0,clk);

  assign z = q5;

  wire xn;
  notGate n(xn,x);

  andGate cd5(d5,q4,x);
  andGate cd4(d4,q3,x);
  andGate cd3(d3,q2,xn);

  wire q1x,q2x;
  andGate cq1x(q1x,q1,x);
  andGate cq2x(q2x,q2,x);
  orGate cd2(d2,q1x,q2x);

  wire q0x,q5x;
  andGate cq0x(q0x,q0,x);
  andGate cq5x(q5x,q5,x);
  orGate cd1(d1,q0x,q5x);

  andGate cd0(d0,q2n,xn);

endmodule 
