`timescale 1ns/1ns

module overlap11011( 
  output z,
  input  x,
  input  init,
  input  clk
);

  wire q5,q5n,q4,q4n,q3,q3n,q2,q2n,q1,q1n,q0,q0n;
  wire d5,d4,d3,d2,d1,d0;
  dffi dff5(q5,q5n,d5,1'b0,init,clk);
  dffi dff4(q4,q4n,d4,1'b0,init,clk);
  dffi dff3(q3,q3n,d3,1'b0,init,clk);
  dffi dff2(q2,q2n,d2,1'b0,init,clk);
  dffi dff1(q1,q1n,d1,1'b0,init,clk);
  dffi dff0(q0,q0n,d0,init,1'b0,clk);

  assign z = q5;

  wire xn;
  notGate n(xn,x);

  wire q0x,q1x,q2x,q3x,q4x,q5x;
  andGate cq0x(q0x,q0,x);
  andGate cq1x(q1x,q1,x);
  andGate cq2x(q2x,q2,x);
  andGate cq3x(q3x,q3,x);
  andGate cq4x(q4x,q4,x);
  andGate cq5x(q5x,q5,x);

  wire q0xn,q1xn,q2xn,q3xn,q4xn,q5xn;
  andGate cq0xn(q0xn,q0,xn);
  andGate cq1xn(q1xn,q1,xn);
  andGate cq2xn(q2xn,q2,xn);
  andGate cq3xn(q3xn,q3,xn);
  andGate cq4xn(q4xn,q4,xn);
  andGate cq5xn(q5xn,q5,xn);


  assign d5=q4x;
  assign d4=q3x;
  orGate cd3(d3,q2xn,q5xn);

  or3Gate cd2(d2,q1x,q2x,q5x);


  assign d1=q0x;

  or4Gate cd0(d0,q0xn,q1xn,q3xn,q4xn);

endmodule 
