`timescale 1ns/1ns

module demuxMulti #(parameter SEL=1,
                              WIDTH=1) (
  output [WIDTH-1:0] out [2**SEL-1:0],
  input  [WIDTH-1:0] in,
  input  [SEL-1:0] sel
);
  for (genvar i = 0; i<WIDTH; i++) begin
    wire [2**SEL-1 : 0] t;

    for (genvar j=0; j<2**SEL; j++) begin
      demux #(SEL) m(t, in[i], sel);
      assign out[j][i:i] = t[j:j];
    end
  end
endmodule