`timescale 1ns/1ns

module counter_tb;

parameter WIDTH=4;
parameter CYCLE=320ns;

  wire clk;
  clock   #(CYCLE/2) clock(clk);

  wire [WIDTH-1:0] d;
  logic reset;
  logic up,down;

  counter #(WIDTH) counter(d, up, down, reset, clk);

  initial begin
    $dumpfile("counter.vcd");
    $dumpvars;

    reset = 1;
    #(CYCLE);
    reset = 0;

    up=1;
    down=0;

    repeat (100) begin
      #240;
      if ($urandom_range(0,10) == 0)
        up = up + 1;
      if ($urandom_range(0,10) == 0)
        down = down + 1;
    end
    $finish;
  end
endmodule
