`timescale 1ns/1ns

module control(
    output [7:0] T,
    input go,
    input  reset,
    input clk
);

//  step 0 on reset or T6 and go clear
    wire goNot, s0, localReset;
    notGate n1(goNot, go);
    andGate a1(s0, T[6], goNot);
    orGate o1(localReset, reset, s0);

    wire up;

    wire [2:0] seq;
    notGate n2(t6Not, T[6:6]);

  
    and(up, t6Not, go);
    counter #(3) s(seq, up, 1'b0, localReset, clk);

    decoder #(3) dec(T, seq);


endmodule
