`timescale 1ns/1ns

module reg1bit_tb;
  wire clk;
  clock   #(80ns) c (clk);

  logic load, in, reset;
  wire out;
  reg1bit r(out, in, load, reset, clk);

  initial begin
    $dumpfile("reg1bit.vcd");
    $dumpvars;

    load = 0;
    in = 0;
    reset = 1;

    repeat (100) begin
      #80ns;
      if (reset == 0) begin
        if ($urandom_range(0,5) == 0)
          reset++;
      end else begin
        if ($urandom_range(0,1) == 0)
          reset++;
      end
      if ($urandom_range(0,1) == 0)
        load++;
      if ($urandom_range(0,2) == 0)
        in++;
    end
    $finish;
  end
endmodule
