`timescale 1ns/1ns

module  register #(parameter WIDTH=1) (
  output [WIDTH-1:0] out,
  input  [WIDTH-1:0] in,  // value to store
  input  down,
  input  up,
  input  load,            // true for load
  input  reset,           // true for reset
  input  clk
);

  wire [2:0] sel;

  assign sel[2] = load;
  assign sel[1] = up;
  assign sel[0] = down;

  wire [WIDTH-1:0] options[7:0];
  for (genvar i=4; i < 8; i++)
    assign options[i] = in;
  for (genvar i=2; i < 4; i++)
    assign options[i] = oneMore;
  assign options[1] = oneLess;
  assign options[0] = d;


  wire [WIDTH-1:0] oneMore,d;
  binaryAdder #(WIDTH) a(,, oneMore, d,
       {{WIDTH-1{1'b0}},1'b1},1'b0);


  wire [WIDTH-1:0] oneLess;
  binaryAdder #(WIDTH) s(,, oneLess, d,
       {{WIDTH{1'b1}}},1'b0);

 
  wire [WIDTH-1:0] in;
  muxMulti #(3,WIDTH) m(in, options, sel);

  regNbit #(WIDTH) r(d, in, load, reset, clk);

endmodule
