`timescale 1ns/1ns

module  seq (
  output found,
  input  in,
  input  reset,
  input  clk
);

  wire [4:0]d;
  register #(5) r(d, 5'b0,in,1'b1,1'b0,
                          1'b0,1'b0,1'b0,
                          reset, clk);

  wire eq;
  comparator #(5) cmp(,eq,,d,5'b01100);

  wire [2:0]step;
  wire work,up;

  orGate o(realReset,reset,work);

  register #(3) cnt(step,3'b0,1'b0,1'b0,1'b0,
                    1'b0,1'b1,1'b0,realReset,clk);
  comparator #(3) cmp5(,work,,step,3'b100);

  andGate mask(found,eq,work);
endmodule
