`timescale 1ns/1ns

module sum #(parameter W=5,parameter N=5) (
    output [W-1:0] out
    );

    wire [W-1:0] s[N];

    assign s[0] = 0;

    for (genvar i = 1; i < N; i++) begin
        wire [W-1:0] t;
        assign t = i;
        binaryAdder #(W) a(,,s[i],s[i-1],t,1'b0);
    end

    assign out = s[N-1];

endmodule
