`timescale 1ns/1ns

module counter #(parameter WIDTH=1) (
  output [WIDTH-1:0] d,
  input up,
  input down,
  input reset,
  input clk
);
  wire load;
  orGate o(load, up, down);

  wire [WIDTH-1:0] in;
  regNbit #(WIDTH) r(d, in, load, reset, clk);

  wire [WIDTH-1:0] options[1:0];
  binaryAdder #(WIDTH) a(,, options[0], d,
       {{WIDTH-1{1'b0}},1'b1},1'b0);
  binaryAdder #(WIDTH) s(,, options[1], d,
       {{WIDTH{1'b1}}},1'b0);

  wire [WIDTH-1:0] o0;
  wire [WIDTH-1:0] o1;
  muxMulti #(1,WIDTH) m(in, options, down);

endmodule
