`timescale 1ns/1ns

module register_tb;

  parameter WIDTH=8;

  wire clk;
  clock #(80) c(clk);

  logic load, reset,up,down,right,left;
  logic shiftIn;
  logic [WIDTH-1:0] in;
  wire [WIDTH-1:0] out;

  register #(WIDTH) r(out,in,shiftIn,
                      right,left,down,
                      up,load,reset,clk);

  initial begin
    $dumpfile("register.vcd");
    $dumpvars;

    load = 0;
    in = 0;
    reset = 1;

    repeat (100) begin
      #80ns;
      if (reset == 0) begin
        if ($urandom_range(0,5) == 0)
          reset++;
      end else begin
        if ($urandom_range(0,1) == 0)
          reset++;
      end
      if ($urandom_range(0,1) == 0)
        load++;
      if ($urandom_range(0,2) == 0)
        in = $urandom_range(0,2**WIDTH-1);
    end
    $finish;
  end

endmodule
