`timescale 1ns/1ns

module  register #(parameter WIDTH=1) (
  output [WIDTH-1:0] out,
  input  [WIDTH-1:0] in,  // value to store
  input  shiftIn,
  input  right,
  input  left,
  input  down,
  input  up,
  input  load,            // true for load
  input  reset,           // true for reset
  input  clk
);

  wire [4:0] sel;
  wire [WIDTH-1:0] oneMore,d;
  wire [WIDTH-1:0] oneLess;
  wire [WIDTH-1:0] shiftLeft;
  wire [WIDTH-1:0] shiftRight;
  wire [WIDTH-1:0] in;

  assign sel[4] = load;
  assign sel[3] = up;
  assign sel[2] = down;
  assign sel[1] = left;
  assign sel[0] = right;

  wire [WIDTH-1:0] options[31:0];
  for (genvar i=16; i < 32; i++)
    assign options[i] = in;
  for (genvar i=8; i < 16; i++)
    assign options[i] = oneMore;
  for (genvar i=4; i < 8; i++)
    assign options[i] = oneLess;
  for (genvar i=2; i < 4; i++)
    assign options[i] = shiftLeft;
  assign options[1] = shiftRight;
  assign options[0] = d;

  binaryAdder #(WIDTH) a(,, oneMore, d,
       {{WIDTH-1{1'b0}},1'b1},1'b0);

  binaryAdder #(WIDTH) s(,, oneLess, d,
       {{WIDTH{1'b1}}},1'b0);

  assign shiftLeft[0] = shiftIn;
  for (genvar i = 0; i < WIDTH-1; i++)
    assign shiftLeft[i+1] = d[i];

  assign shiftRight[WIDTH-1] = shiftIn;
  for (genvar i = 0; i < WIDTH-1; i++)
  begin: sr
    assign shiftRight[i] = d[i+1];
  end


  wire [WIDTH-1:0]value;
  muxMulti #(5,WIDTH) m(value, options, sel);

  wire realLoad;
  or5Gate o(realLoad,load,up,down,right,left);

  regNbit #(WIDTH) rN(d, value, realLoad, reset, clk);

  assign out=d;

endmodule
