`timescale 1ns/1ns

module sumCTL (
    output iClear,
    output iInc,
    output sumClear,
    output sumAdd,
    input  iLEn,
    input  reset,
    input  clk
    );

    wire t0,t1,t2,d0,d1,d2;
    dffi dff0(t0,,d0,reset,1'b0,clk);
    dffi dff1(t1,,d1,1'b0,reset,clk);
    dffi dff2(t2,,d2,1'b0,reset,clk);

    assign d0=0;

    wire iLEnn,t1LE,t1LEn;
    notGate ciLEnn(iLEnn,iLEn);
    andGate ct1LE(t1LE,t1,iLEn);
    andGate ct1LEn(t1LEn,t1,iLEnn);

    orGate cd1(d1,t0,t1LE);
    orGate cd2(d2,t2,t1LEn);

    assign iClear = t0;
    assign sumClear = t0;

    assign iInc = t1LE;
    assign sumAdd = t1LE;
endmodule
