`timescale 1ns/1ns

module timingSignals_tb;

parameter WIDTH=4;

  wire clk;
  clock   #(200) c(clk);

  logic reset;
  wire [WIDTH-1:0] cnt;
  wire [2**WIDTH-1:0] T;

  register #(WIDTH) r(cnt, {WIDTH{1'b0}},1'b0,
         1'b0, 1'b0, 1'b0, 1'b1, 1'b0,reset,clk);
  decoder #(WIDTH) d(T,cnt);

  initial begin
    $dumpfile("timingSignals.vcd");
    $dumpvars;

    reset = 1;
    #130ns;
    reset = 0;
    #20000ns;
    $finish;
  end

endmodule
