`timescale 1ns/1ns

module sumDP #(parameter W=1) (
    output [W-1:0]out,
    output iLEn,
    input  t2,
    input  t1,
    input  t0,
    input  [W-1:0]n,
    input  clk
    );

    wire [W-1:0]sumOut;
    wire [W-1:0]sumPi;
    register #(W) sum(sumOut,sumPi,1'b0,
                        1'b0,1'b0,
                        1'b0,1'b0,
                        tmp,t0,
                        clk);
    assign out = sumOut;

    wire [W-1:0]iOut;
    register #(W) i(iOut,W'(0),1'b0,
                            1'b0,1'b0,
                            1'b0,tmp,
                            t0,1'b0,
                            clk);

    binaryAdder #(W) ba(,,sumPi,sumOut,
                          iOut,1'b0);

    comparator #(W) com(lt,eq,,iOut,n);
    orGate o(iLEn,eq,lt);

    wire tmp;
    andGate incAdd(tmp,t1,iLEn);
    assign iInc = tmp;
    assign sumAdd = tmp;
endmodule
